<?php
     session_start();
      include 'database/shikanisha.kts.php';
        if(!($_SESSION['type'] == 'Manager' || $_SESSION['type'] == 'Cashier' || $_SESSION['type'] == 'Receptionist')){
            header("location:logout.php");
}


?>
<?php  
 
if (isset($_GET['action'])) {
    if ($_GET['action'] == 'clearall') {
        unset($_SESSION['order']);
        header('Location: ./orders.php');
        exit();
    }

    if ($_GET['action'] == 'remove') {
        foreach ($_SESSION['order'] as $key => $value) {
            if ($value['id'] == $_GET['id']) {
                unset($_SESSION['order'][$key]);
                header('Location:./orders.php');
                exit();
            }
        }
    }
}

if(isset($_POST['add'])){
      $id = $_POST['id'];
      $name = $_POST['name'];
      $price = $_POST['price'];
      $qty = $_POST['qty'];
    // Check if store quantity is available before adding to cart
   // Check if store quantity is available before adding to cart
$query_check = "SELECT shop_quantity FROM products WHERE product_id = ?";
$stmt_check = mysqli_prepare($conn, $query_check);

if ($stmt_check) {
    mysqli_stmt_bind_param($stmt_check, "i", $id);
    mysqli_stmt_execute($stmt_check);

    mysqli_stmt_bind_result($stmt_check, $store_quantity);
    mysqli_stmt_fetch($stmt_check);

    if ($store_quantity < $qty) {
        // Product is unavailable
        echo "<script>alert('Product with ID $id the quantity entered is not available.')</script>";
    } else {
        // Product is available
        $products = array('id'=>$id, 'name'=>$name, 'price'=>$price, 'qty'=>$qty);

        // Check if item already exists in cart
        $existing_item = false;
        if(isset($_SESSION['order'])) {
            foreach($_SESSION['order'] as $item) {
                if($item['id'] == $id && $item['qty'] == $qty) {
                    $existing_item = true;
                    break;
                }
            }
        }

        // If item already exists in cart, update its quantity
        if($existing_item) {
            foreach($_SESSION['order'] as &$item) {
                if($item['id'] == $id && $item['qty'] == $qty) {
                    $item['qty'] += $qty;
                    break;
                }
            }
        } else {
            // Add new item to cart
            $_SESSION['order'][] = $products;
        }

        // Display success message
        echo "<script>alert('Product added to cart.')</script>";
    }

    mysqli_stmt_close($stmt_check);
}
}



?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Machakos Cottage Inn</title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="./quixlab/images/favicon.png">
    <!-- Custom Stylesheet -->
    <link href="./quixlab/plugins/tables/css/datatable/dataTables.bootstrap4.min.css" rel="stylesheet">
    <link href="./quixlab/css/style.css" rel="stylesheet">

</head>

<body>

    <!--*******************
        Preloader start
    ********************-->
    <div id="preloader">
        <div class="loader">
            <svg class="circular" viewBox="25 25 50 50">
                <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="3" stroke-miterlimit="10" />
            </svg>
        </div>
    </div>
    <!--*******************
        Preloader end
    ********************-->

    
    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <!--**********************************
            Nav header start
        ***********************************-->
        <div class="nav-header">
            <div class="brand-logo">
                <h1>Order List</h1>
            </div>
        </div>
        <!--**********************************
            Nav header end
        ***********************************-->

        <!--**********************************
            Header start
        ***********************************-->
        <div class="header">    
            <div class="header-content clearfix">
                
                <div class="nav-control">
                    <div class="hamburger">
                        <span class="toggle-icon"><i class="icon-menu"></i></span>
                    </div>
                </div>
                <div class="header-left">
                    <div class="input-group icons">
                        <div class="input-group-prepend">
                            <span class="input-group-text bg-transparent border-0 pr-2 pr-sm-3" id="basic-addon1"><i class="mdi mdi-magnify"></i></span>
                        </div>
                        <input type="search" class="form-control" placeholder="Search Dashboard" aria-label="Search Dashboard">
                        <div class="drop-down   d-md-none">
							<form action="#">
								<input type="text" class="form-control" placeholder="Search">
							</form>
                        </div>
                    </div>
                </div>
                <div class="header-right">
                   
                </div>
            </div>
        </div>
        <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

        <!--**********************************
            Sidebar start
        ***********************************-->
        <div class="nk-sidebar">           
            <div class="card-sm d-flex">
                                      <div class="card-body">
                                          <h4 class="card-title">Order List</h4>
                                          <div class="table-responsive">
                                              <table class="table table-striped table-bordered zero-configuration table-sm">
                                                <thead>
                                                    <tr>
                                                        
                                                        <th scope="col">Name</th>
                                                        <th scope="col">Product Name</th>
                                                         <th scope="col">Price</th>
                                                        <th scope="col">Quantity</th>
                                                        <th scope="col">Subtotal</th>
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                 <tbody>
                                         <?php
                               
                               $total= 0;
                               $amount= 0;   
                               $balance =0;   
                                
                               $output = '';
                               
                               
                               ?>
                                     
                                           
                                       <?php     if (!empty($_SESSION['order'])){
                                  
                                   foreach($_SESSION['order'] as $key =>  $value){ ?>
                                            <tr>
                                               
                                               
                                               <th><?php echo $value['id'];?></th>
                                                <td><?php echo $value['name'];?></td>
                                                <td><?php echo $value['price'];?></td>
                                                <td><?php echo $value['qty'];?></td>
                                                <td><?php echo $value['price']*$value['qty'];?></td>
                                                <td>
                                                  <a href="orders.php?action=remove&id=<?php echo $value['id'];?>">
                                                  <button class="btn btn-danger btn-sm" type="button">Remove</button></a>
                                               </td>
                                               
                                            </tr>
                                           <?php 
													$total = $total + $value['qty'] * $value['price'];   							
											} }?>
                                           
                                            </tbody>
                                            <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Total</th>
                                                <th scope="col"></th>
                                                <th scope="col"></th>
                                                <th scope="col"><?php echo number_format($total, 2); ?></th>
                                                <th scope="col"><a href="orders.php">
                                                <button type="button" class="btn btn-warning btn-sm" >Clear All</button></a>
                                                </th>
                                            </tr>
                                             <tr>
                                                <th scope="col">#</th>
                                                <th scope="col"></th>
                                                <th scope="col"></th>
                                                <th scope="col"></th>
                                                <th scope="col"></th>
                                                <th scope="col">
                                                <button type="button" id="trans" class="btn btn-secondary btn-sm" >Submit</button>
                                                </th>
                                            </tr>
                                           
                                        </thead>
                                        
                                            </table>
                                          </div>
                                      </div>
                                    </div>
        </div>
        <!--**********************************
            Sidebar end
        ***********************************-->

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">

            <div class="row page-titles mx-0">
                <div class="col p-md-0">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
                        <li class="breadcrumb-item active"><a href="logout.php">Log Out</a></li>
                    </ol>
                </div>
            </div>
            <!-- row -->

            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-sm">
                            <div class="card-body">
                                <h4 class="card-title">Inventory</h4>
                                <div class="table-responsive">
                                    <table class="table  table-bordered zero-configuration table-sm">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th>Available</th>
                                                <th>Price</th>
                                                <th>Quantity</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                                <?php
include 'database/shikanisha.kts.php';
                                                  $sql = "select * from products";
                                                  $result=mysqli_query($conn,$sql);
                                                   while($row=mysqli_fetch_array($result)){
                                                ?>
                                                <tr>
                                                    <form method="POST" action="orders.php"> 
                                                    <td><?php echo $row['product_name'] ; ?></td>
                                                    <td><?php echo $row['shop_quantity']; ?></td>
                                                    <td><?php echo $row['selling_price']; ?></td>
                                                     <input type="hidden" name="name" value="<?php echo $row['product_name'];?>" />
												     <input type="hidden" name="id" value="<?php echo $row['product_id'];?>" />
                                                    <input type="hidden" name="price" value="<?php echo $row['selling_price'];?>" class="form-control-sm" />
                                                    <td> <input type="number" class="form-control-sm" id="val-username" name="qty" placeholder="Enter qty needed.." step="any"  required>
                                                    </td>
                                                     <td><button class="btn btn-success bg-success fa fa-shopping-cart btn-sm" type="submit" name="add" value="<?php $row['product_id']; ?>">Order</button></td>
                                                    </form>
                                                </tr>
                                            <?php } ?>
                                           
                                        </tbody>
                                        <tfoot>
                                             <tr>
                                                <th>Name</th>
                                                <th>Available</th>
                                                <th>Price</th>
                                                <th>Quantity</th>
                                                <th>Action</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Orders</h4>
                                <div class="active-member">
                                    <div class="table-responsive">
                                        <table id="bootstrap-data-table-export" class="table table-striped zero-cofiguration table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Seller Name</th>
                                                    <th>Table Name</th>
                                                    <th>Total</th>
                                                    <th>Date</th>
                                                    <th>Action</th>
                                                    <th>Update</th>
                                                </tr>
                                            </thead>
                                             <tbody>
                                              <?php
        
                                                   $sql = "SELECT * FROM orders WHERE seller_name='{$_SESSION['user']}'";
                                                    $result=mysqli_query($conn,$sql);
                                                     while($row=mysqli_fetch_array($result)){
                                                  ?>
                                                <tr>
                                                    <td><?php echo $row['order_id']; ?></td>
                                                    <td>
                                                      <?php echo $row['seller_name']; ?>
                                                    </td>
                                                    <td>
                                                      <?php echo $row['table_name']; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $row['total_amount']; ?>
                                                    </td>
                                                    
                                                    <td>
                                                       <?php echo $row['order_date']; ?>
                                                    </td>
                                                    <td>
																			
             										<i class="fa fa-eye view-order-details" data-id="<?php echo $row['order_id'];?>"></i>

              										</td>
                                                  <td>
                                                    <form action="database/ordertosales.kts.php" method="post">
                                                    <input type="hidden" value="<?php echo $row['order_id'] ?>" name="order_id">
                                                    <button type="submit" class="btn btn-danger">Close Bill</button></form></td> <td>
                                                    <form action="database/updateorder.kts.php" method="post">
                                                    <input type="hidden" value="<?php echo $row['order_id'] ?>" name="order_id">
                                                    <button type="submit" class="btn btn-warning">Update Bill</button></form></td>
                                                </tr>
                                               <?php } ?>
                                               
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>                        
                    </div>
                </div>
                
                
                
                <!-- Transaction Modal -->
                                     <div class="modal fade bd-example-modal-sm" id="transaction"  role="dialog"  tabindex="-1" role="dialog" aria-hidden="true">
                                                
                                        <div class="modal-dialog modal-sm" >
                                                     
                                            <div class="modal-content">
                                               <form method="post" action="./database/orders.kts.php">
                                                <div class="modal-header">
                                               
                                                    <h5 class="modal-title">Table Details</h5>
                                                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                                                    </button>
                                                    
                                                </div>
                                               
                                                <div class="modal-header">
                                                <h4 class="modal-title" name="amount_to_pay" id="amounttopay" value="<?php echo $total; ?>">Total Amount: <?php echo $total; ?></h4>

                                                </div>
                                                <div class="modal-body">
                                                  <div class="table-responsive">
                                                        <table class="table header-border table-hover verticle-middle">
                                                                <thead>
                                                                
                                                                        
                                                                      <tr>
                                                                        <td colspan="3"></td>
                                                                            <th> Table Name</th>
                                                                            <td>
                                                                                <input type="text" class="form-control" name="client_name"  id="client_name" onkeyup="searchClients(this.value)"  required>
                                                                                <div id="clientsDropdown"></div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td colspan="3"></td>
                                                                            <th> Table Id</th>
                                                                            <td><input type="text" class="form-control" name="phone_number" id="phone_number"></td>
                                                                        </tr>
                                                                        
                                                                       <input type="hidden" name="cash" id ="cash" value="'.$total.'">
                                                                       <input type="hidden" name="total" id ="total"  value="<?php echo $total; ?>" >
                                                               
                                                
                                                                </thead>
                                                               
                                                           </table>
                                                               </div>
                                                              
                                                   
                                                </div>
                                                
                                                <div class="modal-footer">
                                                
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    
                                                   <button type="submit" name="transact" class="btn btn-primary">Submit</button>
                                                </div>
                                                </form>
                                         
                    </div>
                 </div>
              </div>
                
                <!-- end of transaction modal -->
                
                    <!-- Add Stock Modal -->
               <div class="modal fade" id="viewOrderDetailsModal">
                  <div class="modal-dialog" role="document">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="viewOrderDetailsModalLabel">Order Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          <div class="modal-body">
                            <div class="row">
                              <div class="col-md-12">
                                <table class="table table-bordered">
                                  <thead>
                                    <tr>
                                      <th>Name</th>
                                      <th>Price</th>
                                      <th>Quantity</th>
                                      <th>Subtotal</th>
                                     
                                     
                                    </tr>
                                  </thead>
                                  <tbody id="orderDetailsTableBody">

                                  </tbody>
                                  <tfoot id="ordertotals">

                                  </tfoot>
                                </table>
                              </div>
                            </div>
                          </div>
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                        </div>
                      </div>
                    </div>
               <!-- End Of aAdd Poduct Modal  -->
           

            </div>
      </div>
            <!-- #/ container -->
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        
      
        
        <!--**********************************
            Footer start
        ***********************************-->
        <div class="footer">
            <div class="copyright">
                <p>Copyright &copy; Designed & Developed by <a href="https://kakashitech.com">Kakashi Tech</a> 2023</p>
            </div>
        </div>
        <!--**********************************
            Footer end
        ***********************************-->
    
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->
    <script src="./quixlab/plugins/common/common.min.js"></script>
    <script src="./quixlab/js/custom.min.js"></script>
    <script src="./quixlab/js/settings.js"></script>
    <script src="./quixlab/js/gleek.js"></script>
    <script src="./quixlab/js/styleSwitcher.js"></script>

    <script src="./quixlab/plugins/tables/js/jquery.dataTables.min.js"></script>
    <script src="./quixlab/plugins/tables/js/datatable/dataTables.bootstrap4.min.js"></script>
    <script src="./quixlab/plugins/tables/js/datatable-init/datatable-basic.min.js"></script>

      <script>
      
  $('#trans').click(function(){
    $('#transaction').modal();
  })    
      </script>
  <script>
    function sub() {
    var numOne = document.getElementById('amounttopay').value;
    var numTwo = document.getElementById('amount_paid').value;
    console.log("numOne:", numOne);
    console.log("numTwo:", numTwo);
    if (numOne == "") numOne = 0;
    if (numTwo == "") numTwo = 0;
    var numOneParsed = parseInt(numOne);
    var numTwoParsed = parseInt(numTwo);
    console.log("numOneParsed:", numOneParsed);
    console.log("numTwoParsed:", numTwoParsed);
    ...
}
</script>
  <script>
// Handle click event on "fa fa-eye" icon
$(document).on('click', '.view-order-details', function() {
  var orderId = $(this).data('id');
  
  // Make an AJAX request to get order details for the selected order ID
  $.ajax({
    url: './database/getorderinfo.kts.php',
    method: 'POST',
    data: {order_id: orderId},
    dataType: 'json',
    success: function(response) {
      // Update the table body with order details
      var tableBody = $('#orderDetailsTableBody');
      tableBody.empty();
      
      var totalSubtotal = 0.00;
      
      for (var i = 0; i < response.length; i++) {
        var item = response[i];
        totalSubtotal += parseFloat(item.subtotal);
        tableBody.append('<tr><td>' + item.product_name + '</td><td>' + item.price + '</td><td>' + item.quantity + '</td><td>' + item.subtotal + '</td></tr>');
      }
      
      tableBody.append('<tr><td colspan="3"><strong>Total:</strong></td><td>' + totalSubtotal + '</td></tr>');
      
      // Show the modal
      $('#viewOrderDetailsModal').modal('show');
    },
    error: function(xhr, status, error) {
      alert('Error: ' + error);
    }
  });
});

</script>

  <script>
   function searchClients(keyword) {
    // Make an AJAX request to search for clients by name
    $.ajax({
        url: 'database/searchtable.kts.php',
        method: 'POST',
        data: { keyword: keyword },
        success: function(response) {
            // Show the search results in a dropdown
            $('#clientsDropdown').html(response);
            $('#clientsDropdown').show();
        },
        error: function(xhr, status, error) {
            console.error(xhr);
        }
    });
}

// Listen for changes to the client name input
$('input[name="client_name"]').on('input', function() {
    var keyword = $(this).val();
    if (keyword.length > 0) {
        // Search for clients
        searchClients(keyword);
    } else {
        // Hide the search results dropdown
        $('#clientsDropdown').hide();
    }
});

// Listen for clicks on a search result
$(document).on('click', '.client-result', function() {
    // Get the client ID, name, and phone number
    var clientId = $(this).data('id');
    var clientName = $(this).data('name');
    var phoneNumber = $(this).data('phone');
    
    // Update the client name and phone number inputs and hide the search results dropdown
    $('input[name="client_name"]').val(clientName);
    $('input[name="phone_number"]').val(phoneNumber);
    $('#clientsDropdown').hide();
    
    // Update the hidden client ID input
    $('#clientIdInput').val(clientId);
});

    </script>
<script>
  // Add event listener to the input field
  document.getElementById('val-username').addEventListener('input', function(e) {
    // Get the user's input
    const input = e.target.value.trim();
    
    // Check if the input is a whole number
    if (Number.isInteger(parseFloat(input))) {
      // Input is a whole number, so set the step attribute to 1
      e.target.step = 1;
    } else {
      // Input is not a whole number, so set the step attribute to any
      e.target.step = "any";
    }
  });
</script>
</body>

</html>