<?php
     session_start();
      include 'database/shikanisha.kts.php';
        if(!($_SESSION['type'] == 'Manager' || $_SESSION['type'] == 'Procurement')){
            header("location:logout.php");
}


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Machakos Cottage Inn</title>
    <!-- Favicon icon -->
    <link rel="icon" type="./quixlab/image/png" sizes="16x16" href="./quixlab/images/favicon.png">
    <!-- Pignose Calender -->
    <link href="./quixlab/plugins/pg-calendar/css/pignose.calendar.min.css" rel="stylesheet">
    <!-- Chartist -->
    <link rel="stylesheet" href="./quixlab/plugins/chartist/css/chartist.min.css">
    <link rel="stylesheet" href="./quixlab/plugins/chartist-plugin-tooltips/css/chartist-plugin-tooltip.css">
    <!-- Custom Stylesheet -->
    <link href="./quixlab/css/design.css" rel="stylesheet">
    <!-- DataTables with Buttons -->
    <link rel="stylesheet" href="./quixlab/plugins/tables/css/datatable/dataTables.bootstrap4.min.css">
    <link href="./quixlab/plugins/tables/css/datatable/dataTables.bootstrap4.min.css" rel="stylesheet">
    <link href="./quixlab/css/buttons.bootstrap.min.css" rel="stylesheet" />
    

</head>

<body>

    <!--*******************
        Preloader start
    ********************-->
    <div id="preloader">
        <div class="loader">
            <svg class="circular" viewBox="25 25 50 50">
                <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="3" stroke-miterlimit="10" />
            </svg>
        </div>
    </div>
    <!--*******************
        Preloader end
    ********************-->

    
    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <!--**********************************
            Nav header start
        ***********************************-->
        <div class="nav-header" style="background-image: url('./quixlab/images/room.png');">
        </div>
        <!--**********************************
            Nav header end
        ***********************************-->

        <!--**********************************
            Header start
        ***********************************-->
        <div class="header">    
            <div class="header-content clearfix">
                
                <div class="nav-control">
                    <div class="hamburger">
                        <span class="toggle-icon"><i class="icon-menu"></i></span>
                    </div>
                </div>
                <div class="header-left">
                    <div class="input-group icons">
                        <div class="input-group-prepend">
                            <span class="input-group-text bg-transparent border-0 pr-2 pr-sm-3" id="basic-addon1"><i class="mdi mdi-magnify"></i></span>
                        </div>
                        <input type="search" class="form-control" placeholder="Search Dashboard" aria-label="Search Dashboard">
                        <div class="drop-down animated flipInX d-md-none">
                            <form action="#">
                                <input type="text" class="form-control" placeholder="Search">
                            </form>
                        </div>
                    </div>
                </div>
               
            </div>
        </div>
        <!--**********************************
            Nav header end
        ***********************************-->

        <!--**********************************
            Header start
        ***********************************-->
     <?php


// Define arrays for each user role and the corresponding allowed links
$managerLinks = array(
    "orders.php", 
    "table.php", 
    "payments.php", 
    "reports.php", 
    "purchases.php", 
    "accomodation.php", 
    "employee.php", 
    "inventory.php"
);

$cashierLinks = array(
    "orders.php", 
    "table.php", 
    "payments.php"
);

$receptionistLinks = array(
    "orders.php", 
    "payments.php", 
    "accomodation.php", 
    "table.php"
);

// Check if user is logged in and their role is set in the session
if(isset($_SESSION['type'])) {
    $role = $_SESSION['type'];
    
    // Assign the corresponding links based on the user role
    switch($role) {
        case "Manager":
            $links = $managerLinks;
            break;
        case "Cashier":
            $links = $cashierLinks;
            break;
        case "Receptionist":
            $links = $receptionistLinks;
            break;
        default:
            $links = array();
            break;
    }
} else {
    // Redirect user to login page if they are not logged in
    header("Location: login.php");
    exit();
}

?>

<div class="nk-sidebar">           
    <div class="nk-nav-scroll">
        <ul class="metismenu" id="menu">
            <li class="nav-label">Dashboard</li>
            <li>
                <a class="has-arrow" href="javascript:void()" aria-expanded="false">
                    <i class="icon-speedometer menu-icon"></i><span class="nav-text">Dashboard</span>
                </a>
                <ul aria-expanded="false">
                    <li><a href="index.php">Dashboard</a></li>
                    <!-- <li><a href="./index-2.html">Home 2</a></li> -->
                </ul>
            </li>
            <?php 
               foreach($links as $link) {
    $linkText = ucfirst(str_replace(".php", "", $link)); // remove .php extension and capitalize first letter
    echo '<li><a href="' . $link . '"><i class="icon-menu menu-icon"></i><span class="nav-text">' . $linkText . '</span></a></li>';
}

            ?>
            <li>
                <a href="logout.php" aria-expanded="false">
                    <i class="icon-lock menu-icon"></i><span class="nav-text">LogOut</span>
                </a>
            </li>
        </ul>
    </div>
</div>


        <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

        <!--**********************************
            Sidebar start
        ***********************************-->
    
        <!--**********************************
            Sidebar end
        ***********************************-->

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid mt-3">
                <div class="row">
                   <?php
                     include 'database/shikanisha.kts.php';
                     $sql="SELECT SUM(total) AS total_amount, 
       SUM(amount_received) AS total_amount_received, 
       SUM(CASE WHEN payment_method = 'till' THEN amount_received ELSE 0 END) AS till, 
       SUM(CASE WHEN payment_method = 'cash' THEN amount_received ELSE 0 END) AS cash,
       SUM(CASE WHEN payment_method = 'merchant' THEN amount_received ELSE 0 END) AS merchant,
       SUM(amount_received) as total,
       SUM(total) - SUM(amount_received) AS debts
FROM transaction_receipts
WHERE seller_date BETWEEN DATE_SUB(DATE_SUB(CURDATE(), INTERVAL 1 DAY), INTERVAL 6 HOUR) AND DATE_SUB(CURDATE(), INTERVAL 6 HOUR)
                              ";
                     $result = mysqli_query($conn, $sql);
                     while($row=mysqli_fetch_array($result)){
                    ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="card gradient-1">
                            <div class="card-body">
                                <h3 class="card-title text-white">Total Sales</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo $row['total']; ?></h2>
                                    <p class="text-white mb-0">Tot Amount</p>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-money"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="card gradient-2">
                           <div class="card-body">
                                <h3 class="card-title text-white">Till Number</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo $row['till']; ?></h2>
                                    <p class="text-white mb-0">Total Deposited</p>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-money"></i></span>
                            </div>  
                        </div>
                    </div>
                   
                    <div class="col-lg-2 col-sm-6">
                        <div class="card gradient-12">
                            <div class="card-body">
                                <h3 class="card-title text-white">Cash</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo $row['cash']; ?></h2>
                                    <p class="text-white mb-0">Amount Paid</p>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-money"></i></span>
                            </div>
                        </div>
                    </div>
                       <div class="col-lg-2 col-sm-6">
                        <div class="card gradient-5">
                            <div class="card-body">
                                <h3 class="card-title text-white">Debt</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo $row['debts']; ?></h2>
                                    <p class="text-white mb-0">Pending Amount</p>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-money"></i></span>
                            </div>
                        </div>
                    </div> <div class="col-lg-2 col-sm-6">
                        <div class="card gradient-7">
                            <div class="card-body">
                                <h3 class="card-title text-white">Merchant</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo $row['merchant']; ?></h2>
                                    <p class="text-white mb-0">Amount Paid</p>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-money"></i></span>
                            </div>
                        </div>
                    </div>
              </div>
                    <?php } ?>
                    
                </div>
                  
                
                 <div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Waiter Detailed Report</h4>
                <div class="basic-form">
                    <form action="reports.php?redirect_url=reports.php" method="post">
                        <div class="form-row align-items-center">
                            <div class="col-auto">
                                <label class="sr-only">Waiter Name</label>
                                <input type="text" name="clients_names" class="form-control mb-2" placeholder="Search Cashier" onkeyup="searchClients(this.value)">
                                <div id="clientsDropdown"></div>
                            </div>
                            <div class="col-auto">
                                <label class="sr-only">Start Date</label>
                                <div class="input-group mb-2">
                                    <input type="datetime-local" name="start" class="form-control" placeholder="End Date and Time">
                                </div>
                            </div>
                            <div class="col-auto">
                                <label class="sr-only">End Date</label>
                                <div class="input-group mb-2">
                                    <input type="datetime-local" name="end" class="form-control" placeholder="End Date and Time">
                                </div>
                            </div>
                            <div class="col-auto">
                                <button type="submit" name="datefilter" class="btn btn-dark mb-2">Generate User Report</button>&nbsp;&nbsp;
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <?php 
            include_once('database/shikanisha.kts.php');
            if(isset($_POST['datefilter'])){
                $seller_name = $_POST['clients_names'];
                $start_date = $_POST['start'];
                $end_date = $_POST['end'];
                $start_datetime = date('Y-m-d H:i:s', strtotime($start_date));
                $end_datetime = date('Y-m-d H:i:s', strtotime($end_date));

                $sql = "SELECT 
                            tr.seller_name,
                            SUM(s.subtotal) AS total_sales_amount,
                            s.product_id AS product_id,
                            s.product_name AS product_name,
                            SUM(s.quantity) AS total_products_sold
                        FROM sales s
                        JOIN transaction_receipts tr ON s.trans_id = tr.trans_id
                        WHERE tr.seller_name ='$seller_name'  
                        AND tr.seller_date BETWEEN '$start_datetime' AND '$end_datetime'
                        GROUP BY tr.seller_name, s.product_id
                        ORDER BY s.product_name;";
                $result = mysqli_query($conn,$sql);
                if(mysqli_num_rows($result) > 0) {
                    $sales_data = array();
                    while($row = mysqli_fetch_assoc($result)) {
                        $sales_data[] = $row;
                    }
            
                    // Generate the modal HTML
                    $modal_html = '<div class="modal fade" id="viewClientSalesModal">
                  <div class="modal-dialog" role="document">
                       <form id="deletesale">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="viewOrderDetailsModalLabel">'.$seller_name.' Sales Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          <div class="modal-body">
                            <div class="row">
                              <div class="col-lg-12 col-md-12">
                                <table id="empTable"class="table table-striped table-bordered zeroc-configuration">
                                  <thead>
                                    <tr>
                                      <th>Product Name</th>
                                      <th>Total Products</th>
                                      <th>Total Sales Amount</th>
                                    </tr>
                                  </thead>
                                  <tbody>';
            foreach($sales_data as $sale) {
                $modal_html .= '<tr>
                                      <td>'.$sale['product_name'].'</td>
                                      <td>'.$sale['total_products_sold'].'</td>
                                      <td>'.$sale['total_sales_amount'].'</td>
                                  </tr>';
            }
            $modal_html .= '</tbody></table> <div class="btn-group">
                    <button class="btn btn-sm btn-primary buttons-csv" tabindex="0" aria-controls="empTable" type="button">
                        <span>CSV</span>
                    </button>
                    <button class="btn btn-sm btn-primary buttons-excel" tabindex="0" aria-controls="empTable" type="button">
                        <span>Excel</span>
                    </button>
                </div></div></div></div></form></div>';
            
            // Print the modal HTML
            echo $modal_html;
            
            // Show the modal using jQuery
            echo '<script>$(document).ready(function() { $("#viewClientSalesModal").modal("show"); });</script>';
        }
        else {
            echo 'No Results Found';
        }
    }
?>
  </div>
</div>
                 <div class="row">
  <div class="col-lg-12 col-sm-6">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">Items Report</h4>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                <label for="start_date">Start Date:</label>
                <input type="datetime-local" class="form-control" id="start_date" name="start_date">
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="end_date">End Date:</label>
                <input type="datetime-local" class="form-control" id="end_date" name="end_date">
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <button type="submit" class="btn btn-primary mt-4">Generate Report</button>
              </div>
            </div>
          </div>
        </form>
        <?php if(isset($_POST['start_date']) && isset($_POST['end_date'])) {
          $start_date = $_POST['start_date'];
          $end_date = $_POST['end_date'];
          $sql = "SELECT s.product_id, s.product_name,s.selling_price, SUM(s.subtotal) as total_subtotal, SUM(s.quantity) as total_quantity
            FROM sales s
            JOIN transaction_receipts t ON s.trans_id = t.trans_id
            WHERE t.seller_date >= '$start_date' AND t.seller_date <= '$end_date'
            GROUP BY s.product_name;";
          $result=mysqli_query($conn,$sql);
          ?>
          <div class="active-member">
            <div class="table-responsive">
              <table id="saleskTable" class="table table-striped table-bordered >
                  <div class="btn-group">
    <button class="btn btn-sm btn-primary buttons-csv" tabindex="0" aria-controls="salesTable" type="button">
        <span>CSV</span>
    </button>
    <button class="btn btn-sm btn-primary buttons-excel" tabindex="0" aria-controls="salesTable" type="button">
        <span>Excel</span>
    </button>
    <button class="btn btn-sm btn-primary buttons-pdf" tabindex="0" aria-controls="salesTable" type="button">
        <span>PDF</span>
    </button>
</div>

                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Price</th>
                    <th>Quantity</th>
                    <th>Subtotal</th>
                  </tr>
                </thead>
               <tbody>
  <?php 
  $total_price = 0;
  $total_quantity = 0;
  while($row=mysqli_fetch_array($result)) { 
    $total_price += $row['selling_price'] * $row['total_quantity'];
   
  ?>
  <tr>
    <td><?php echo $row['product_id']; ?></td>
    <td><?php echo $row['product_name']; ?></td>
    <td><?php echo $row['selling_price']; ?></td>
    <td><?php echo $row['total_quantity']; ?></td>
    <td><?php echo $row['total_subtotal']; ?></td>
  </tr>
  <?php } ?>
  
</tbody>
<tfoot>
<tr>
   
    <td colspan="3"></td>
     <td colspan=""><b><i>Total</i></b></td>
    <td><b><i><?php echo $total_price; ?></i></b></td>
  </tr>
</tfoot>

              </table>
               
            </div>
          </div>
        <?php } ?>
      </div>
    </div>
  </div>
</div>
 
                 <div class="row">
                    <div class="col-lg-12 col-sm-6">
                      <div class="card">
                              <div class="card-body">
                                <h4 class="card-title">Transactions</h4>
                                <div class="active-member">
                                    <div class="table-responsive">
                                        <table id="bootstrap-data-table-export" class="table table-striped table-bordered zero-configuration">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Seller Name</th>
                                                    <th>Total</th>
                                                    <th>Paid Amount</th>
                                                    <th>Status</th>
                                                    <th>Date</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                             <tbody>
                                              <?php
        
                                                    $sql = "select * from transaction_receipts order by trans_id desc";
                                                    $result=mysqli_query($conn,$sql);
                                                     while($row=mysqli_fetch_array($result)){
                                                  ?>
                                                <tr>
                                                    <td><?php echo $row['trans_id']; ?></td>
                                                    <td>
                                                      <?php echo $row['seller_name']; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $row['total']; ?>
                                                    </td>
                                                     <td>
                                                     <?php echo $row['amount_received']; ?>
                                                     </td>
                                                    <td><?php if ($row['amount_received'] == $row['total']){ echo'<span class="badge badge-success">Paid</span>
                                                        ';}else if($row['amount_received'] < $row['total']){ echo'
                                                        
														<span class="badge badge-warning">Pending</span>';}else if($row['amount_received'] > $row['total']){ echo'
                                                        
														<span class="badge badge-danger">Overpayment</span>';}?>
                                                    </td>
                                                   
                                                    <td>
                                                       <?php echo $row['seller_date']; ?>
                                                    </td>
                                                    <td>
                                                    <button class="btn btn-info" onclick="viewOrderDet(<?php echo $row['trans_id'];?>)">View Details</button>
                                                    </td>
                                                </tr>
                                               <?php } ?>
                                               
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
               </div> 
               <div class="row">
                    <div class="col-lg-12 col-sm-6">
                      <div class="card">
                              <div class="card-body">
                                <h4 class="card-title">Member Sales Status</h4>
                                <div class="active-member">
                                    <div class="table-responsive">
                                        <table id="bootstrap-data-table-export" class="table table-striped table-bordered zero-configuration">
                                            <thead>
                                                <tr>
                                                    
                                                    <th>Seller Name</th>
                                                    <th>Total Sales</th>
                                                    <th>Paid Amount</th>
                                                    <th>Debt</th>
                                                    <th>Status</th>
                                                    
                                                </tr>
                                            </thead>
                                             <tbody>
                                              <?php
        
                                                    $sql = "SELECT 
    `seller_name`,
    SUM(`amount_received`) AS amount_collected,
    SUM(`total`) AS total_sales,
    SUM(`total`) - SUM(`amount_received`) AS debt
FROM 
    `transaction_receipts`
GROUP BY 
    `seller_name`
";
                                                    $result=mysqli_query($conn,$sql);
                                                     while($row=mysqli_fetch_array($result)){
                                                  ?>
                                                <tr>
                                                   
                                                    <td>
                                                      <?php echo $row['seller_name']; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $row['total_sales']; ?>
                                                    </td>
                                                     <td>
                                                     <?php echo $row['amount_collected']; ?>
                                                     </td>
                                                      <td>
                                                       <?php echo $row['debt']; ?>
                                                      </td>
                                                    <td><?php if ($row['amount_collected'] == $row['total_sales']){ echo'<span class="badge badge-success">Paid</span>
                                                        ';}else if($row['amount_collected'] < $row['total_sales']){ echo'
                                                        
														<span class="badge badge-warning">Pending</span>';}else if($row['amount_collected'] > $row['total_sales']){ echo'
                                                        
														<span class="badge badge-danger">Overpayment</span>';}?>
                                                    </td>
                                                   
                                                   
                                                    
                                                </tr>
                                               <?php } ?>
                                               
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
               </div>
               
             <div class="row">
                    <div class="col-lg-12 col-md-6">
                     <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Monthly Waiter Report</h4>
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered zero-configuration table-sm" >
                                        <thead>
                                            <tr>
                                                
                                                <th>Seller_Name</th>
                                                <th>Total_Amount</th>
                                               
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
        
                                                    $sql = "SELECT   tr.seller_name,
                                                                SUM(s.subtotal) AS total_sales
                                                            FROM sales s
                                                            JOIN transaction_receipts tr ON s.trans_id = tr.trans_id
                                                            WHERE MONTH(tr.seller_date) = MONTH(CURRENT_DATE()) AND YEAR(tr.seller_date) = YEAR(CURRENT_DATE())
                                                            GROUP BY tr.seller_name
                                                            ORDER BY total_sales DESC;";
                                                    $result=mysqli_query($conn,$sql);
                                                     while($row=mysqli_fetch_array($result)){
                                                  ?>
                                            
                                            <tr>
                                                <td><?php echo $row['seller_name']; ?></td>
                                                <td><?php echo $row['total_sales']; ?></td>
                                                
                                            </tr>
                                             <?php } ?> 
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th>Total Amt</th>
                                                <th></th>
                                            </tr>
                                         
                                            
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>  
                
                  
                <div class="row">
                  <div class="col-lg-12 col-md-6">
                      <div class="card">
                             <div class="card-body">
                                <h4 class="card-title">Weekly Report</h4>
                                    <div class="table-responsive">
                                        <table class="table table-striped table-bordered zero-configuration table-sm"  >
                                            <thead>
                                                <tr>
                                                    <th>Transaction Method</th>
                                                    <th>Transaction Amount</th>
                                                    
                                                </tr>
                                            </thead>
                                             <tbody>
   
                                               <?php
                                                  // get start and end date of current week
                                                  $start_date = date('Y-m-d', strtotime('this week'));
                                                  $end_date = date('Y-m-d', strtotime('this week +6 days'));

                                                  // calculate total sales for each transaction method
                                                  $sql = "SELECT payment_method, SUM(amount_received) AS total_sales FROM transaction_receipts WHERE seller_date BETWEEN '$start_date' AND '$end_date' GROUP BY payment_method";
                                                  $result = mysqli_query($conn, $sql);
                                                  while($row=mysqli_fetch_array($result)){
                                                  ?>
                                                <tr>
                                                    <td><?php echo $row['payment_method']; ?></td>
                                                    <td>
                                                      <?php echo $row['total_sales']; ?>
                                                    </td>
                                                    
                                                </tr>
                                             <?php } ?>
                                               
                                            </tbody>
                                            <tfoot>
                                            <tr>
                                             <td></td>
                                              <?php

                                              // calculate total lump sum transactions for current week
                                              $sql = "SELECT SUM(amount_received) AS weekly_total
                                              FROM transaction_receipts
                                              WHERE seller_date BETWEEN DATE_SUB(NOW(), INTERVAL (DAYOFWEEK(NOW())-2) DAY) AND DATE_ADD(NOW(), INTERVAL (8-DAYOFWEEK(NOW())) DAY);
                                              ";
                                              $result = mysqli_query($conn, $sql);
                                              $row = mysqli_fetch_assoc($result);

                                              // print result
                                              ?>
                                               <td> <?php echo $row['weekly_total'] ; ?></td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
          </div> 
                <div class="row">
                  <div class="col-lg-12 col-sm-6">
                      <div class="card">
                             <div class="card-body">
                                <h4 class="card-title">Daily Transaction Report</h4>
                                    <div class="table-responsive">
                                        <table class="table table-striped table-bordered zero-configuration table-sm"  >
                                            <thead>
                                                <tr>
                                                    <th>Transaction Method</th>
                                                    <th>Transaction Amount</th>
                                                    
                                                </tr>
                                            </thead>
                                             <tbody>
   
                                                   <?php
                                                    // get start and end date of current week
                                                    $start_date = date('Y-m-d', strtotime('this week'));
                                                    $end_date = date('Y-m-d', strtotime('this week +6 days'));

                                                    // calculate total sales for each transaction method
                                                    $sql = "SELECT payment_method, SUM(amount_received) AS total_sales 
                                                            FROM transaction_receipts 
                                                            WHERE seller_date >= DATE(NOW()) AND seller_date < DATE_ADD(DATE(NOW()), INTERVAL 1 DAY) 
                                                            GROUP BY payment_method;";
                                                    $result = mysqli_query($conn, $sql);
                                                    while($row=mysqli_fetch_array($result)){
                                                                                                      ?>
                                                <tr>
                                                    <td><?php echo $row['payment_method']; ?></td>
                                                    <td>
                                                      <?php echo $row['total_sales']; ?>
                                                    </td>
                                                    
                                                </tr>
                                               <?php } ?>
                                               
                                            </tbody>
                                            <tfoot>
                                            <tr>
                                             <td></td>
                                              <?php

// calculate total lump sum transactions for current week
$sql = "SELECT SUM(amount_received) AS daily_total 
FROM transaction_receipts 
WHERE seller_date >= DATE(NOW()) AND seller_date < DATE_ADD(DATE(NOW()), INTERVAL 1 DAY);
";
$result = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($result);

// print result


?>                   <td> <?php echo $row['daily_total'] ; ?></td>
                                    </tr>
                                            </tfoot>
                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
          </div>
                             <!-- Add Stock Modal -->
               <div class="modal fade" id="viewOrderDetailsModal">
                  <div class="modal-dialog" role="document">
                       <form id="deletesale">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="viewOrderDetailsModalLabel">Transaction Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          <div class="modal-body">
                            <div class="row">
                              <div class="col-md-12">
                                <table class="table table-bordered">
                                  <thead>
                                    <tr>
                                      <th>Name</th>
                                      <th>Price</th>
                                      <th>Quantity</th>
                                      <th>Subtotal</th>
                                     
                                     
                                    </tr>
                                  </thead>
                                  <tbody id="orderDetailsTableBody">

                                  </tbody>
                                  <tfoot id="ordertotals">

                                  </tfoot>
                                </table>
                              </div>
                            </div>
                          </div>
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                  <button type="submit" class="btn btn-danger" >Delete Sale</button>
                                </div>
                        </div>
                        </form>
                      </div>
                    </div>
               <!-- End Of aAdd Poduct Modal  -->
                   <!-- Add Stock Modal -->
                   <!-- End Of aAdd Poduct Modal  -->
                 
            </div>
            <!-- #/ container -->
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        
        
        <!--**********************************
            Footer start
        ***********************************-->
        <div class="footer">
            <div class="copyright">
                <p>Copyright &copy; Designed & Developed by <a href="https://kakashitech.com">Kakashi Tech</a></p>
            </div>
        </div>
        <!--**********************************
            Footer end
        ***********************************-->
  
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
***********************************-->
    <script src="./quixlab/plugins/common/common.min.js"></script>
    <script src="./quixlab/js/custom.min.js"></script>
    <script src="./quixlab/js/settings.js"></script>
    <script src="./quixlab/js/gleek.js"></script>
    <script src="./quixlab/js/styleSwitcher.js"></script>

    <!-- Chartjs -->
    <script src="./quixlab/plugins/chart.js/Chart.bundle.min.js"></script>
    <!-- Circle progress -->
    <script src="./quixlab/plugins/circle-progress/circle-progress.min.js"></script>
    <!-- Datamap -->
    <script src="./quixlab/plugins/d3v3/index.js"></script>
    <script src="./quixlab/plugins/topojson/topojson.min.js"></script>
    <script src="./quixlab/plugins/datamaps/datamaps.world.min.js"></script>
    <!-- Morrisjs -->
    <script src="./quixlab/plugins/raphael/raphael.min.js"></script>
    <script src="./quixlab/plugins/morris/morris.min.js"></script>
    <!-- Pignose Calender -->
    <script src="./quixlab/plugins/moment/moment.min.js"></script>
    <script src="./quixlab/plugins/pg-calendar/js/pignose.calendar.min.js"></script>
    <!-- ChartistJS -->
    <script src="./quixlab/plugins/chartist/js/chartist.min.js"></script>
    <script src="./quixlab/plugins/chartist-plugin-tooltips/js/chartist-plugin-tooltip.min.js"></script>
    <script src="./quixlab/js/dashboard/dashboard-1.js"></script>
    <script src="./quixlab/plugins/chart.js/Chart.bundle.min.js"></script>
    <script src="./quixlab/js/plugins-init/chartjs-init.js"></script>
    <!-- Datatables -->
    <script src="./quixlab/js/dashboard/dashboard-1.js"></script>
    <script src="./quixlab/plugins/tables/js/jquery.dataTables.min.js"></script>
    <script src="./quixlab/plugins/tables/js/datatable/dataTables.bootstrap4.min.js"></script>
    <script src="./quixlab/plugins/tables/js/datatable-init/datatable-basic.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/vfs_fonts.js"></script>

    <script src="./quixlab/js/data-table/dataTables.buttons.min.js"></script>
    <script src="./quixlab/js/data-table/buttons.flash.min.js"></script>
    <script src="./quixlab/js/data-table/jszip.min.js"></script>
    <script src="./quixlab/js/data-table/pdfmake.min.js"></script>
    <script src="./quixlab/js/data-table/vfs_fonts.js"></script>
    <script src="./quixlab/js/data-table/buttons.html5.min.js"></script>
    <script src="./quixlab/js/data-table/buttons.print.min.js"></script>
    <script src="./quixlab/js/data-table/datatables-init.js"></script>
    <script>
    $(document).ready(function() {
        <?php if(mysqli_num_rows($result) > 0) { ?>
            $('#viewClientSalesModal').modal('show');
        <?php } ?>
    });
</script>
<script>
    $(document).ready(function() {
        $('#empTable').DataTable({
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'csv',
                    exportOptions: {
                        columns: [0, 1, 2] // include columns 0, 1, and 2 in the CSV export
                    }
                },
                {
                    extend: 'excel',
                    exportOptions: {
                        columns: [0, 1, 2] // include columns 0, 1, and 2 in the Excel export
                    }
                }
            ]
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('#saleskTable').DataTable({
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'csv',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4] // include all columns in the CSV export
                    }
                },
                {
                    extend: 'excel',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4] // include all columns in the Excel export
                    }
                },
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape', // set PDF orientation to landscape
                    pageSize: 'LEGAL', // set PDF page size to legal
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4] // include all columns in the PDF export
                    }
                }
            ]
        });
    });
</script>

<script>
	$(document).ready(function() {
		// Add event listener to form submit button
		$('#deletesale').on('submit', function(event) {
			event.preventDefault(); // Prevent default form submission behavior

			// Serialize form data
			var formData = $(this).serialize();

			// Send AJAX request to server
			$.ajax({
				url: './database/saledelete.kts.php', // PHP script to handle the request
				type: 'POST',
				data: formData,
				success: function(response) {
                    // Display the response from the PHP script
                    alert(response);

                    // Clear the form input fields
                    $('#deletesale')[0].reset();

                    // Reload the current page
                    location.reload();
                },
				error: function(xhr, status, error) {
					// Handle errors
					console.log(xhr.responseText);
				}
			});
		});
	});
</script>

	<script>
  //redirect_on_modal_close
  
 
	$(document).ready(function() {
  var redirectUrl = new URLSearchParams(window.location.search).get('redirect_url');
  $("#viewClientSalesModal").modal("show");
  // After the modal is hidden, redirect to the specified URL
  $("#viewClientSalesModal").on("hidden.bs.modal", function() {
    window.location.href = redirectUrl;
  });
});
 </script>
	
	<script>
   function searchClients(keyword) {
    // Make an AJAX request to search for clients by name
    $.ajax({
        url: 'database/search_employees.kts.php',
        method: 'POST',
        data: { keyword: keyword },
        success: function(response) {
            // Show the search results in a dropdown
            $('#clientsDropdown').html(response);
            $('#clientsDropdown').show();
        },
        error: function(xhr, status, error) {
            console.error(xhr);
        }
    });
}

// Listen for changes to the client name input
$('input[name="clients_names"]').on('input', function() {
    var keyword = $(this).val();
    if (keyword.length > 0) {
        // Search for clients
        searchClients(keyword);
    } else {
        // Hide the search results dropdown
        $('#clientsDropdown').hide();
    }
});

// Listen for clicks on a search result
$(document).on('click', '.client-result', function() {
    // Get the client ID, name, and phone number
    var clientName = $(this).data('name');
    
    // Update the client name and phone number inputs and hide the search results dropdown
    $('input[name="clients_names"]').val(clientName);
    $('#clientsDropdown').hide();
});

    </script>
  
    
   <script>
  function  viewOrderDet(receiptId) {
  // Make an AJAX request to get order details for the selected receipt ID
  $.ajax({
    url: './database/getsalesinfo.kts.php',
    method: 'POST',
    data: {receipt_id: receiptId},
    dataType: 'json',
    success: function(response) {
      // Update the table body with order details
      var tableBody = $('#orderDetailsTableBody');
      tableBody.empty();

      var totalSubtotal = 0.00;

      for (var i = 0; i < response.length; i++) {
        var item = response[i];
        totalSubtotal += parseFloat(item.subtotal);
        tableBody.append('<tr><td>' + item.product_name + '</td><td>' + item.selling_price + '</td><td>' + item.quantity + '</td><td>' + item.subtotal + '</td></tr>');
      }

      tableBody.append('<tr><td colspan="3"><input type="hidden" name="receipt_id" id="receipt_id" value="'+receiptId+'"></td><td></td></tr>');
      tableBody.append('<tr><td colspan="3"><strong>Total:</strong></td><td>' + totalSubtotal + '</td></tr>');

      // Show the modal
      $('#viewOrderDetailsModal').modal('show');
    },
    error: function(xhr, status, error) {
      alert('Error: ' + error);
    }
  });
}

  
  </script>

<!-- JavaScript code to populate the chart with the JSON data -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


</body>

</html>