<script>
 $(document).ready(function() {
  // Initialize the DataTable
  var table = $('.items-table').dataTable({
    pageLength: 500,
    buttons: [
      'copy', 'excel', 'pdf', 'print'
    ],
    ajax: {
      url: './database/get_products.kts.php',
      type: 'GET',
      dataSrc: ''
    },
    columns: [
      { data: 'product_id' },
      { data: 'product_name' },
      { data: 'company' },
      { data: 'buying_price' },
      { data: 'selling_price' },
      { data: 'shop_quantity' },
      {
        // Update button column
        render: function(data, type, row) {
          return '<button class="btn btn-primary update-product" data-product-id="' + row.product_id + '">Update</button>';
        }
      },
      {
        // Delete button column
        render: function(data, type, row) {
          return '<button class="btn btn-danger delete-product" data-product-id="' + row.product_id + '">Delete</button>';
        }
      }
    ]
  });

  // Add click handlers for the update and delete buttons
  $('.items-table tbody').on('click', '.update-product', function() {
    var productId = $(this).data('product-id');
   
    // Make an AJAX call to retrieve the current product details
    $.ajax({
      url: './database/get_products.kts.php',
      type: 'POST',
      data: { 'product_id': productId },
      success: function(response) {
        try {
          // Parse the response JSON and populate the modal fields
          var products = JSON.parse(response);
          $('#product-id-input').val(products.product_id);
          $('#product-name-input').val(products.product_name);
          $('#company-input').val(products.company);
          $('#buying-price-input').val(products.buying_price);
          $('#selling-price-input').val(products.selling_price);
          $('#store-quantity-input').val(products.store_quantity);
          $('#shop-quantity-input').val(products.shop_quantity);
          // Display the modal
          $('#update-product-modal').modal('show');
        } catch (e) {
          console.error('Failed to parse server response:', e);
        }
      },
      error: function(jqXHR, textStatus, errorThrown) {
        console.error('AJAX error:', errorThrown);
      }
    });
   
  });

  $('.items-table tbody').on('click', '.delete-product', function() {
    var productId = $(this).data('product-id');
    // Make an AJAX call to delete the product from the server
    $.ajax({
      url: './database/delete_product.kts.php',
      type: 'POST',
      data: { 'product_id': productId },
      success: function(response) {
        // Refresh the table data
        table.ajax.reload();
      },
      error: function(jqXHR, textStatus, errorThrown) {
        console.error('AJAX error:', errorThrown);
      }
    });
  });

  // Check if the DataTable has already been initialized
  if ($.fn.dataTable.isDataTable('.items-table')) {
    // Destroy the existing DataTable before initializing it again
    $('.items-table').DataTable().destroy();
    table = $('.items-table').dataTable({
      pageLength: 500,
      buttons: [
        'copy', 'excel', 'pdf', 'print'
      ],
      ajax: {
        url: './database/get_products.kts.php',
        type: 'GET',
        dataSrc: ''
      },
      columns: [
        { data: 'product_id' },
        { data: 'product_name' },
        { data: 'company' },
        { data: 'buying_price' },
        { data: 'selling_price' },
        { data: 'shop_quantity' },
        {
          // Update button column
          render: function(data, type, row) {
            return '<button class="btn btn-primary update-product" data-product-id="' + row.product_id + '">Update</button>';
          }
        },
        {
          // Delete button column
          render: function(data, type, row) {
            return '<button class="btn btn-danger delete-product" data-product-id="' + row.product_id + '">Delete</button>';
          }
        }
      ]
    });
  }
});
	
	
<script>
    $(document).ready(function() {
        // Load table data via AJAX
        var table = $('.items-table').DataTable({
            ajax: {
                url: './database/get_products.kts.php',
                type: 'GET',
                dataSrc: ''
            },
            columns: [
                { data: 'product_id' },
                { data: 'product_name' },
                { data: 'company' },
                { data: 'buying_price' },
                { data: 'selling_price' },
                { data: 'shop_quantity' },
                {
                    // Update button column
                    render: function(data, type, row) {
                        return '<button class="btn btn-primary update-product" data-product-id="' + row.product_id + '">Update</button>';
                    }
                },
                {
                    // Delete button column
                    render: function(data, type, row) {
                        return '<button class="btn btn-danger delete-product" data-product-id="' + row.product_id + '">Delete</button>';
                    }
                }
            ]
        });

        // Update button click handler
        $('.items-table tbody').on('click', '.update-product', function() {
            var productId = $(this).data('product-id');
            // Make an AJAX call to retrieve the current product details
            $.ajax({
                url: './database/get_product.kts.php',
                type: 'POST',
                data: { 'product_id': productId },
                success: function(response) {
                    // Parse the response JSON and populate the modal fields
                    var product = JSON.parse(response);
                    $('#product-id').val(product.product_id);
                    $('#product-name').val(product.product_name);
                    $('#company').val(product.company);
                    $('#buying-price').val(product.buying_price);
                    $('#selling-price').val(product.selling_price);
                    $('#store-qty').val(product.store_quantity);
                    $('#shop-qty').val(product.shop_quantity);
                    // Display the modal
                    $('#update-product-modal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.error(errorThrown);
                }
            });
        });

        // Delete button click handler
        $('.items-table tbody').on('click', '.delete-product', function() {
            var productId = $(this).data('product-id');
            // Make an AJAX call to delete the product from the server
            $.ajax({
                url: './database/delete_product.kts.php',
                type: 'POST',
                data: { 'product_id': productId },
                success: function(response) {
                    // Refresh the table data
                    table.ajax.reload();
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.error(errorThrown);
                }
            });
        });
    });
</script>
	
	
	<script>
$(document).ready(function() {
  // Initialize DataTables
  $('#bootstrap-data-table-export').DataTable();

  // Handle row click event on DataTables table
  $('#bootstrap-data-table-export tbody').on('click', 'tr', function() {
    var table = $('#bootstrap-data-table-export').DataTable();
    var row = table.row(this);
    var receiptId = row.data()[0]; // assuming receipt_id is in the first column
    
    var totalSubtotal = 0;
    
    
    
    
    
    // Make an AJAX request to get order details for the selected receipt ID
    $.ajax({
      url: 'database/empinfo.kts.php',
      method: 'POST',
      data: {receipt_id: receiptId},
      dataType: 'json',
      success: function(response) {
        // Update the table body with order details
        var tableBody = $('#orderDetailsTableBody');
        tableBody.empty();
        
        for (var i = 0; i < response.length; i++) {
          var item = response[i];
         
          tableBody.append('<tr><td>' + item.name + '</td><td>' + item.phone_number + '</td><td>' + item.password + '</td></tr>');
          
         
        }
               
        // Show the modal
         // Show the modal
       
        //display modal
          $('#viewOrderDetailsModal').modal('show');
        
      },
      error: function(xhr, status, error) {
        alert('Error: ' + error);
      }
    });
  });
});

</script>
 <script>
$(document).ready(function() {
  // Initialize DataTables
  $('#bootstrap-data-table-export').DataTable();

  // Handle row click event on DataTables table
  $('#bootstrap-data-table-export tbody').on('click', 'tr', function() {
    var table = $('#bootstrap-data-table-export').DataTable();
    var row = table.row(this);
    var receiptId = row.data()[0]; // assuming receipt_id is in the first column
    
   alert(receiptId);
    
    
    // Make an AJAX request to get order details for the selected receipt ID
    $.ajax({
      url: 'database/empinfo.kts.php',
      method: 'POST',
      data: {receipt_id: receiptId},
      dataType: 'json',
      success: function(response) {
        // Update the table body with order details
        var tableBody = $('#orderDetailsTableBody');
        tableBody.empty();
        
        for (var i = 0; i < response.length; i++) {
          var item = response[i];
         
          tableBody.append('<tr><td>' + item.name + '</td><td>' + item.phone_number + '</td><td>' + item.password + '</td></tr>');
          
         
        }
           // Show the modal
         // Show the modal
       
        //display modal
          $('#viewOrderDetailsModal').modal('show');
        
      },
      error: function(xhr, status, error) {
        alert('Error: ' + error);
      }
    });
  });
});

</script>

<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Waiter Detailed Report</h4>
                <div class="basic-form">
                    <form action="reports.php?redirect_url=reports.php" method="post">
                        <div class="form-row align-items-center">
                            <div class="col-auto">
                                <label class="sr-only">Waiter Name</label>
                                <input type="text" name="clients_names" class="form-control mb-2" placeholder="Search Cashier" onkeyup="searchClients(this.value)">
                                <div id="clientsDropdown"></div>
                            </div>
                            <div class="col-auto">
                                <label class="sr-only">Start Date</label>
                                <div class="input-group mb-2">
                                    <input type="datetime-local" name="start" class="form-control" placeholder="End Date and Time">
                                </div>
                            </div>
                            <div class="col-auto">
                                <label class="sr-only">End Date</label>
                                <div class="input-group mb-2">
                                    <input type="datetime-local" name="end" class="form-control" placeholder="End Date and Time">
                                </div>
                            </div>
                            <div class="col-auto">
                                <button type="submit" name="datefilter" class="btn btn-dark mb-2">Generate User Report</button>&nbsp;&nbsp;
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <?php 
            include_once('database/shikanisha.kts.php');
            if(isset($_POST['datefilter'])){
                $seller_name = $_POST['clients_names'];
                $start_date = $_POST['start'];
                $end_date = $_POST['end'];
                $start_datetime = date('Y-m-d H:i:s', strtotime($start_date));
                $end_datetime = date('Y-m-d H:i:s', strtotime($end_date));

                $sql = "SELECT 
                            tr.seller_name,
                            SUM(s.subtotal) AS total_sales_amount,
                            s.product_id AS product_id,
                            s.product_name AS product_name,
                            SUM(s.quantity) AS total_products_sold
                        FROM sales s
                        JOIN transaction_receipts tr ON s.trans_id = tr.trans_id
                        WHERE tr.seller_name ='$seller_name'  
                        AND tr.seller_date BETWEEN '$start_datetime' AND '$end_datetime'
                        GROUP BY tr.seller_name, s.product_id
                        ORDER BY s.product_name;";
                $result = mysqli_query($conn,$sql);
                if(mysqli_num_rows($result) > 0) {
                    $sales_data = array();
                    while($row = mysqli_fetch_assoc($result)) {
                        $sales_data[] = $row;
                    }
            
                    // Generate the modal HTML
                    $modal_html = '<div class="modal fade" id="viewClientSalesModal">
                  <div class="modal-dialog" role="document">
                       <form id="deletesale">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="viewOrderDetailsModalLabel">'.$seller_name.' Sales Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          <div class="modal-body">
                            <div class="row">
                              <div class="col-lg-12 col-md-12">
                                <table class="table table-bordered">
                                  <thead>
                                    <tr>
                                      <th>Product Name</th>
                                      <th>Total Products</th>
                                      <th>Total Sales Amount</th>
                                    </tr>
                                  </thead>
                                  <tbody>';
            foreach($sales_data as $sale) {
                $modal_html .= '<tr>
                                      <td>'.$sale['product_name'].'</td>
                                      <td>'.$sale['total_products_sold'].'</td>
                                      <td>'.$sale['total_sales_amount'].'</td>
                                  </tr>';
            }
            $modal_html .= '</tbody></table></div></div></div></form></div>';
            
            // Print the modal HTML
            echo $modal_html;
            
            // Show the modal using jQuery
            echo '<script>$(document).ready(function() { $("#viewClientSalesModal").modal("show"); });</script>';
        }
        else {
            echo 'No Results Found';
        }
    }
?>




