<?php

session_start();

// Check if any POST data is present
if (!empty($_POST)) {
    $id    = $_POST['id'] ?? '';
    $name  = $_POST['name'] ?? '';
    $qty   = $_POST['qty'] ?? '';

    $price = isset($_POST['price']) && $_POST['price'] === 'custom' ? ($_POST['custom_price'] ?? '') : ($_POST['price'] ?? '');

    if ($id && $name && $qty !== '' && $price !== '') {
        // Your database connection details
        $servername = "your_server_name";
        $username = "your_username";
        $password = "your_password";
        $dbname = "your_database_name";

        // Create connection
        $conn = mysqli_connect($servername, $username, $password, $dbname);

        // Check connection
        if (!$conn) {
            die("Connection failed: " . mysqli_connect_error());
        }

        $query_check = "SELECT shop_quantity FROM products WHERE product_id = ?";
        $stmt_check = mysqli_prepare($conn, $query_check);

        if ($stmt_check) {
            mysqli_stmt_bind_param($stmt_check, "i", $id);
            mysqli_stmt_execute($stmt_check);

            mysqli_stmt_bind_result($stmt_check, $store_quantity);
            mysqli_stmt_fetch($stmt_check);

            if ($store_quantity < $qty) {
                // Product is unavailable
                $response = array("status" => "error", "message" => "Product quantity requested is unavailable.");
            } else {
                // Product is available, add to cart
                $session_array = array(
                    'id'    =>  $id,
                    'name'  =>  $name,
                    'price' =>  $price,
                    'qty'   =>  $qty
                );

                if (!empty($_SESSION['cart'])) {
                    $session_array_id = array_column($_SESSION['cart'], 'id');
                    if (in_array($id, $session_array_id)) {
                        foreach ($_SESSION['cart'] as $key => $val) {
                            if ($_SESSION['cart'][$key]['id'] === $id) {
                                if (!empty($qty)) {
                                    $_SESSION['cart'][$key]['qty'] = $_SESSION['cart'][$key]['qty'] + $qty;
                                }
                            }
                        }
                    } else {
                        if (!empty($qty)) {
                            $_SESSION['cart'][] = $session_array;
                        }
                    }
                } else {
                    if (!empty($qty)) {
                        $_SESSION['cart'][] = $session_array;
                    }
                }

                // Return success response
                $response = array("status" => "success", "message" => "Item added to cart.");
            }
        } else {
            // Return error response
            $response = array("status" => "error", "message" => mysqli_error($conn));
        }

        // Close the prepared statement
        mysqli_stmt_close($stmt_check);

        // Close the database connection
        mysqli_close($conn);

    } else {
        // Invalid or incomplete data
        $response = array("status" => "error", "message" => "Invalid or incomplete data.");
    }
} else {
    // No POST data received
    $response = array("status" => "error", "message" => "No data received.");
}

// Send JSON response back to the client
header('Content-Type: application/json');
echo json_encode($response);
?>
