<?php
// Include your database connection code
require '../../database/shikanisha.kts.php';

// Process the received dates
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];
$totalCostSum = 0;

// Fetch the sum of amount_received from transaction_receipts table based on selected dates
$queryAmountPaid = $conn->prepare("SELECT SUM(amount_received) AS amountPaidSum FROM transaction_receipts WHERE seller_date BETWEEN ? AND ?");
$queryAmountPaid->bind_param("ss", $startDate, $endDate);
$queryAmountPaid->execute();
$resultAmountPaid = $queryAmountPaid->get_result();
$amountPaidSum = 0;
if ($resultAmountPaid) {
    $rowAmountPaid = $resultAmountPaid->fetch_assoc();
    $amountPaidSum = $rowAmountPaid['amountPaidSum'];
}

// Calculate debt based on the difference between total and amount_received
$queryDebt = $conn->prepare("SELECT (SUM(total) - SUM(amount_received)) AS debt FROM transaction_receipts WHERE seller_date BETWEEN ? AND ?");
$queryDebt->bind_param("ss", $startDate, $endDate);
$queryDebt->execute();
$resultDebt = $queryDebt->get_result();
$debt = 0;
if ($resultDebt) {
    $rowDebt = $resultDebt->fetch_assoc();
    $debt = $rowDebt['debt'];
}

// Fetch accounts payable from vendor_debts table
$queryAccountsPayable = "SELECT SUM(amount_owed) AS accountsPayable FROM vendor_debts";
$resultAccountsPayable = $conn->query($queryAccountsPayable);
$accountsPayable = 0;
if ($resultAccountsPayable) {
    $rowAccountsPayable = $resultAccountsPayable->fetch_assoc();
    $accountsPayable = $rowAccountsPayable['accountsPayable'];
}

// Fetch total profit from sales, products, and transaction_receipts tables
$queryTotalProfit = $conn->prepare("SELECT SUM((s.selling_price - p.buying_price) * s.quantity) AS totalProfit
                                    FROM sales s
                                    JOIN products p ON s.product_id = p.product_id
                                    JOIN transaction_receipts t ON s.trans_id = t.trans_id
                                    WHERE t.seller_date BETWEEN ? AND ?");
$queryTotalProfit->bind_param("ss", $startDate, $endDate);
$queryTotalProfit->execute();
$resultTotalProfit = $queryTotalProfit->get_result();
$totalProfit = 0;
if ($resultTotalProfit) {
    $rowTotalProfit = $resultTotalProfit->fetch_assoc();
    $totalProfit = $rowTotalProfit['totalProfit'];
}

// Fetch expenses from the expenses table
$queryExpenses = $conn->prepare("SELECT SUM(expense_amount) AS totalExpenses FROM expenses WHERE date_incurred BETWEEN ? AND ?");
$queryExpenses->bind_param("ss", $startDate, $endDate);
$queryExpenses->execute();
$resultExpenses = $queryExpenses->get_result();
$totalExpenses = 0;
if ($resultExpenses) {
    $rowExpenses = $resultExpenses->fetch_assoc();
    $totalExpenses = $rowExpenses['totalExpenses'];
}

// Fetch purchases from purchase_orders table joined with invoice table to get the dates
$queryPurchases = $conn->prepare("SELECT SUM(amount_transacted) AS totalPurchases
                                         FROM vendor_transactions
                                         WHERE transaction_type = 'Purchase' AND date BETWEEN ? AND ?");
$queryPurchases->bind_param("ss", $startDate, $endDate);
$queryPurchases->execute();
$resultPurchases = $queryPurchases->get_result();
$totalPurchases = 0;
if ($resultPurchases) {
    $rowPurchases = $resultPurchases->fetch_assoc();
    $totalPurchases = $rowPurchases['totalPurchases'];
}

// Fetch purchase payments from vendor_transactions table where transaction_type is 'debit'
$queryPurchasePayments = $conn->prepare("SELECT SUM(amount_transacted) AS totalPurchaseExpenses
                                         FROM vendor_transactions
                                         WHERE transaction_type = 'debit' AND date BETWEEN ? AND ?");
$queryPurchasePayments->bind_param("ss", $startDate, $endDate);
$queryPurchasePayments->execute();
$resultPurchasePayments = $queryPurchasePayments->get_result();
$totalPurchaseExpenses = 0;
if ($resultPurchasePayments) {
    $rowPurchasePayments = $resultPurchasePayments->fetch_assoc();
    $totalPurchaseExpenses = $rowPurchasePayments['totalPurchaseExpenses'];
}

// Close the database connection
$conn->close();

// Calculate the net profit
$netProfit = $totalProfit - ($totalExpenses + $totalPurchaseExpenses);

echo '<div class="text-center mb-4">';
echo '    <h2 class="mb-0">Balance Sheet</h2>';
echo '    <hr class="my-4">';
echo '</div>';

echo '<div class="row">';
echo '    <div class="col-md-6">';
echo '        <h3>Assets</h3>';
echo '        <table class="table">';
echo '            <tbody>';
echo '                <tr>';
echo '                    <th scope="row">Cash & Cash Equivalents</th>';
echo '                    <td>' . ($totalCostSum + $amountPaidSum) . '</td>';
echo '                </tr>';
echo '                <tr>';
echo '                    <th scope="row">Accounts Receivable</th>';
echo '                    <td>' . $debt . '</td>';
echo '                </tr>';
echo '                <tr>';
echo '                    <th scope="row">Total Purchases</th>';
echo '                    <td>' . $totalPurchases . '</td>';
echo '                </tr>';
// Add other Assets items as needed
echo '            </tbody>';
echo '        </table>';
echo '    </div>';

echo '    <div class="col-md-6">';
echo '        <h3>Liabilities</h3>';
echo '        <table class="table">';
echo '            <tbody>';
echo '                <tr>';
echo '                    <th scope="row">Accounts Payable</th>';
echo '                    <td>' . $accountsPayable . '</td>';
echo '                </tr>';
// Add other Liabilities items as needed
echo '            </tbody>';
echo '        </table>';

echo '        <h3>Equity</h3>';
echo '        <table class="table">';
echo '            <tbody>';
echo '                <tr>';
echo '                    <th scope="row">Gross Profit</th>';
echo '                    <td>' . $totalProfit . '</td>';
echo '                </tr>';
echo '                <tr>';
echo '                    <th scope="row">Net Profit</th>';
echo '                    <td>' . $netProfit . '</td>';
echo '                </tr>';
// Add other Equity items as needed
echo '            </tbody>';
echo '        </table>';
echo '    </div>';
echo '</div>';

?>
