<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Assuming you have established a database connection named $conn
    
    // Extracting POST data
    $id    = $_POST['id'];
    $name  = $_POST['name'];
    $qty   = $_POST['qty'];

    // Product is available, add to items-order
    $session_array = array(
        'id'    =>  $id,
        'name'  =>  $name,
        'qty'   =>  $qty
    );

    // Check if $_SESSION['items-order'] exists and is not empty
    if (!empty($_SESSION['items-order'])) {
        // Extract the IDs of items in the session
        $session_array_id = array_column($_SESSION['items-order'], 'id');
        if (in_array($id, $session_array_id)) {
            // If the item with the same ID is already in the session, update its quantity
            foreach ($_SESSION['items-order'] as $key => $val) {
                if ($_SESSION['items-order'][$key]['id'] === $id) {
                    if (!empty($qty)) {
                        $_SESSION['items-order'][$key]['qty'] += $qty;
                    }
                }
            }
        } else {
            // If the item is not in the session, add it
            if (!empty($qty)) {
                $_SESSION['items-order'][] = $session_array;
            }
        }
    } else {
        // If $_SESSION['items-order'] does not exist or is empty, add the item
        if (!empty($qty)) {
            $_SESSION['items-order'][] = $session_array;
        }
    }

    // Prepare JSON response
    $response = array(
        'success' => true,
        'message' => 'Product added to order list successfully'
    );
} else {
    // Invalid request
    $response = array(
        'success' => false,
        'message' => 'Invalid request'
    );
}

// Send JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>
