<?php
include_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['trans_id'])) {
    $transId = $conn->real_escape_string($_POST['trans_id']);

    // Start a transaction
    $conn->begin_transaction();

    try {
        // Select sales data
        $selectSalesStmt = $conn->prepare("SELECT product_id, product_name, quantity FROM sales WHERE trans_id = ?");
        $selectSalesStmt->bind_param("i", $transId);
        $selectSalesStmt->execute();
        $salesResult = $selectSalesStmt->get_result();

        // Update the products table for each product
        while ($sale = $salesResult->fetch_assoc()) {
            $quantityToUpdate = $sale['quantity'];
            $productId = $sale['product_id'];
            $productName = $sale['product_name'];

            // Deduct the sold quantity from the specified product
            if (strpos($productName, 'CHIPS') !== false) {
                $productName = 'potato';
                $quantityToUpdate *= 600;
            } else if (strpos($productName, 'FISH') !== false) {
                // Adjust this block based on your specific logic for product names
                if (strpos($productName, '250GM') !== false) {
                    $productName = 'FISH 250GM';
                } elseif (strpos($productName, '400GM') !== false) {
                    $productName = 'FISH 400GM';
                } elseif (strpos($productName, '500GM') !== false) {
                    $productName = 'FISH 500GM';
                } elseif (strpos($productName, '600GM') !== false) {
                    $productName = 'FISH 600GM';
                } elseif (strpos($productName, '700GM') !== false) {
                    $productName = 'FISH 700GM';
                } elseif (strpos($productName, '800GM') !== false) {
                    $productName = 'FISH 800GM';
                } elseif (strpos($productName, '900GM') !== false) {
                    $productName = 'FISH 900GM';
                } elseif (strpos($productName, '1KG') !== false) {
                    $productName = 'FISH 1KG';
                } else {
                    $productName = ''; // No specific fish type found, set product name to empty
                }
            } else {
                $productName = ''; // Adjust this based on your actual product name
            }

            if (!empty($productName)) {
                // Update the shop_quantity of the specified product by name
                $updateProductStmt = $conn->prepare("UPDATE products SET shop_quantity = shop_quantity + ? WHERE product_name = ?");
                $updateProductStmt->bind_param("ds", $quantityToUpdate, $productName);
            } else {
                // Update the shop_quantity of the specified product by ID if no name criteria are met
                $updateProductStmt = $conn->prepare("UPDATE products SET shop_quantity = shop_quantity + ? WHERE product_id = ?");
                $updateProductStmt->bind_param("di", $quantityToUpdate, $productId);
            }

            if (!$updateProductStmt->execute()) {
                throw new Exception('Failed to update product quantity.');
            }

            $updateProductStmt->close();
        }

        $selectSalesStmt->close();

        $selectAmountStmt = $conn->prepare("SELECT `amount_received`, `phone_number` FROM `transaction_receipts` WHERE `trans_id` = ?");
        $selectAmountStmt->bind_param("i", $transId);
        $selectAmountStmt->execute();
        $amountResult = $selectAmountStmt->get_result();

        if ($amountResult->num_rows > 0) {
            $amountData = $amountResult->fetch_assoc();
            $amountReceived = $amountData['amount_received'];
            $phoneNumber = $amountData['phone_number'];

            // Get customer_id using phone_number
            $selectCustomerStmt = $conn->prepare("SELECT `customer_id` FROM `customers` WHERE `phone_number` = ?");
            $selectCustomerStmt->bind_param("s", $phoneNumber);
            $selectCustomerStmt->execute();
            $customerResult = $selectCustomerStmt->get_result();

            if ($customerResult->num_rows > 0) {
                $customerData = $customerResult->fetch_assoc();
                $customerId = $customerData['customer_id'];

                // Update client_acc
                $updateClientAccStmt = $conn->prepare("UPDATE `client_acc` SET `amount_owed` = `amount_owed` - ? WHERE `client_id` = ?");
                $updateClientAccStmt->bind_param("di", $amountReceived, $customerId);

                if (!$updateClientAccStmt->execute()) {
                    throw new Exception('Failed to update client account.');
                }
                $updateClientAccStmt->close();
            }

            $selectCustomerStmt->close();
        }
        $selectAmountStmt->close();

        // Prepare SQL statements to delete records
        $stmt1 = $conn->prepare("DELETE FROM transaction_receipts WHERE trans_id = ?");
        $stmt2 = $conn->prepare("DELETE FROM payments WHERE trans_id = ?");
        $stmt3 = $conn->prepare("DELETE FROM sales WHERE trans_id = ?");
        $stmt4 = $conn->prepare("DELETE FROM `client_trans` WHERE `stid` = ?");

        // Bind parameters
        $stmt1->bind_param("i", $transId);
        $stmt2->bind_param("i", $transId);
        $stmt3->bind_param("i", $transId);
        $stmt4->bind_param("i", $transId);

        // Execute delete statements
        $deleteSuccess = $stmt1->execute() && $stmt2->execute() && $stmt3->execute() && $stmt4->execute();

        // Close the statements
        $stmt1->close();
        $stmt2->close();
        $stmt3->close();
        $stmt4->close();

        if ($deleteSuccess) {
            // If all deletes are successful, commit the transaction
            $conn->commit();
            echo json_encode(['success' => true]);
        } else {
            throw new Exception('Failed to delete records.');
        }

    } catch (Exception $e) {
        // If any exception occurs, rollback and send an error response
        $conn->rollback();
        echo json_encode(['error' => $e->getMessage()]);
    }
} else {
    // If it's an invalid request, send an error response
    echo json_encode(['error' => 'Invalid request']);
}
?>
