<?php 
include_once('shikanisha.kts.php');

// Check for the actual data being posted rather than 'datefilter'
if(isset($_POST['clients_names'], $_POST['start'], $_POST['end'])){
    $seller_name = $_POST['clients_names'];
    $start_date = $_POST['start'];
    $end_date = $_POST['end'];
    $start_datetime = date('Y-m-d H:i:s', strtotime($start_date));
    $end_datetime = date('Y-m-d H:i:s', strtotime($end_date));

    $sql = "SELECT 
                tr.seller_name,
                SUM(s.subtotal) AS total_sales_amount,
                s.product_id AS product_id,
                s.product_name AS product_name,
                SUM(s.quantity) AS total_products_sold
            FROM sales s
            JOIN transaction_receipts tr ON s.trans_id = tr.trans_id
            WHERE tr.seller_name = ?  
            AND tr.seller_date BETWEEN ? AND ?
            GROUP BY tr.seller_name, s.product_id
            ORDER BY s.product_name;";
    
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        // Handle error here
        error_log('mysqli prepare() failed: ');
        error_log( print_r( htmlspecialchars($stmt->error), true ) );
        exit('Error: Check your server logs.');
    }
    
    $stmt->bind_param("sss", $seller_name, $start_datetime, $end_datetime);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $sales_data = array();
    while($row = $result->fetch_assoc()) {
        $sales_data[] = $row;
    }
    
    // Now you can echo out the data or handle it as needed
  
   header('Content-Type: application/json');
    echo json_encode($sales_data);
    $stmt->close();
}
?>
