<?php
// Include your database connection code here, and ensure $conn is defined.
include_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $response = array();

    // Get start and end dates from the form submission
    $start = isset($_POST['startz']) ? $_POST['startz'] : null;
    $end = isset($_POST['endz']) ? $_POST['endz'] : null;

    if ($start && $end) {
        // Prepare the SQL query for payment methods excluding 'Invoice Payment'
        $sql = "SELECT p.payment_method, SUM(p.amount) AS tills
                FROM payments AS p
                JOIN transaction_receipts AS tr ON p.trans_id = tr.trans_id
                WHERE tr.seller_date BETWEEN ? AND ? AND tr.payment_method != 'Invoice Payment' 
                GROUP BY p.payment_method";

        // Prepare the SQL query for 'Invoice Payment'
        $invoicesql = "SELECT p.payment_method, SUM(p.amount) AS tills
                       FROM payments AS p
                       JOIN transaction_receipts AS tr ON p.trans_id = tr.trans_id
                       WHERE tr.seller_date BETWEEN ? AND ? AND tr.payment_method = 'Invoice Payment' 
                       GROUP BY p.payment_method";

        if ($stmt = $conn->prepare($sql)) {
            // Bind the parameters
            $stmt->bind_param("ss", $start, $end);

            // Execute the statement
            $stmt->execute();

            // Get the result
            $result = $stmt->get_result();

            if ($result) {
                // Prepare and execute the query for 'Invoice Payment'
                if ($invoiceStmt = $conn->prepare($invoicesql)) {
                    $invoiceStmt->bind_param("ss", $start, $end);
                    $invoiceStmt->execute();
                    $invoiceResult = $invoiceStmt->get_result();

                    // Calculate the total from the transaction_receipts table including 'Invoice Payment'
                    $totalSql = "SELECT SUM(total) AS total FROM transaction_receipts WHERE seller_date BETWEEN ? AND ?";
                    
                    if ($totalStmt = $conn->prepare($totalSql)) {
                        // Bind the parameters
                        $totalStmt->bind_param("ss", $start, $end);

                        // Execute the statement
                        $totalStmt->execute();

                        // Get the result
                        $totalResult = $totalStmt->get_result();
                        $totalRow = $totalResult->fetch_assoc();
                        $monthlyTotal = $totalRow['total'];

                        $reportData = '';
                        $tillsTotal = 0;
                        $nonInvoiceTotal = 0;

                        // Process results for non-'Invoice Payment'
                        while ($row = $result->fetch_assoc()) {
                            $reportData .= '<tr>
                                <td>' . $row['payment_method'] . '</td>
                                <td>' . $row['tills'] . '</td>
                            </tr>';
                            $tillsTotal += $row['tills'];
                            $nonInvoiceTotal += $row['tills'];
                            
                        }

                        // Process results for 'Invoice Payment'
                        while ($row = $invoiceResult->fetch_assoc()) {
                            $reportData .= '<tr>
                                <td>' . $row['payment_method'] . ' (Invoice)</td>
                                <td>' . $row['tills'] . '</td>
                            </tr>';
                            $tillsTotal += $row['tills'];
                        }

                        // Calculate the debt excluding 'Invoice Payment'
                        $debtSql = "SELECT SUM(total) AS total FROM transaction_receipts WHERE payment_method != 'Invoice Payment' AND seller_date BETWEEN ? AND ?";
                        if ($debtStmt = $conn->prepare($debtSql)) {
                            $debtStmt->bind_param("ss", $start, $end);
                            $debtStmt->execute();
                            $debtResult = $debtStmt->get_result();
                            $debtRow = $debtResult->fetch_assoc();
                            $debtTotal = $debtRow['total'];

                            // Calculate the debt
                            $debt = $debtTotal - $nonInvoiceTotal;

                            // Include debt in the reportData
                            $reportData .= '<tr>
                                <td>Debt</td>
                                <td>' . $debt . '</td>
                            </tr>';

                            $response['success'] = true;
                            $response['reportData'] = $reportData;
                            $response['monthlyTotal'] = $monthlyTotal;
                            $response['debtData'] = $debt;
                        } else {
                            $response['success'] = false;
                            $response['message'] = 'Error preparing debt SQL query.';
                        }
                    } else {
                        $response['success'] = false;
                        $response['message'] = 'Error preparing total SQL query.';
                    }

                    // Close the invoice statement
                    $invoiceStmt->close();
                } else {
                    $response['success'] = false;
                    $response['message'] = 'Error preparing invoice SQL query.';
                }
            } else {
                $response['success'] = false;
                $response['message'] = 'Error executing the SQL query for payment methods.';
            }

            // Close the statement
            $stmt->close();
        } else {
            $response['success'] = false;
            $response['message'] = 'Error preparing payment methods SQL query.';
        }
    } else {
        $response['success'] = false;
        $response['message'] = 'Invalid start or end date.';
    }

    // Close the total statement if it was prepared
    if (isset($totalStmt) && $totalStmt) {
        $totalStmt->close();
    }

    // Return the response as JSON
    header('Content-type: application/json');
    echo json_encode($response);
} else {
    // Handle non-POST requests
    $response['success'] = false;
    $response['message'] = 'Invalid request method.';
    header('Content-type: application/json');
    echo json_encode($response);
}
?>
