<?php
require_once('shikanisha.kts.php');
// Assuming you have a database connection established
$accId = $_POST['acc_id'];

// Query to get client_id and amount_owed
$query = "SELECT `client_id`,`amount_owed` FROM `client_acc` WHERE `acc_id` = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $accId); // Bind the parameter
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$client_id = $row['client_id'];
$amount_owed = $row['amount_owed'];

// Query to get transactions
$query2 = "SELECT * FROM `client_trans` WHERE `client_id` = ?";
$stmt2 = $conn->prepare($query2);
$stmt2->bind_param("i", $client_id); // Bind the parameter
$stmt2->execute();
$result2 = $stmt2->get_result();
$transactions = '';
while($row2 = $result2->fetch_assoc()){
    // Process each row and append to $transactions
    $transactions .= '<tr>';
    $transactions .= '<td>' . $row2['stid'] . '</td>';
    $transactions .= '<td>' . $row2['amount'] . '</td>';
    $transactions .= '<td>' . $row2['type'] . '</td>';
    $transactions .= '<td>' . $row2['method'] . '</td>';
    $transactions .= '<td>' . $row2['date'] . '</td>';
    if($row2['type'] === 'Payment') {
        // If type is "Payment", generate a delete button
        $transactions .= '<td><button class="btn btn-danger deletepayment-btn" data-trans-id="' . $row2['trans_id'] . '" onclick="deletepaymenttransaction(this)">Delete</button></td>';
    } else {
        // If type is not "Payment", leave the cell empty
        $transactions .= '<td></td>';
    }
    // Add more columns if needed
    $transactions .= '</tr>';
}

// Prepare data to be sent back
$response = array(
    'transactions' => $transactions,
    'amount_owed' => $amount_owed
);

echo json_encode($response);
?>
