<?php
session_start();
require_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $postData = json_decode(file_get_contents("php://input"), true);

    $customerId = 1;
    $phone = $_SESSION['phone'];
    $method = $postData['payment_method'];
    $amount = $postData['amount_paid'];
    $descr = ''; // Default description
    $type = 'Backdating'; // Default type
    $username = $_SESSION['user'];
    $cash = $postData['cash'];
    $date = $postData['date'];
    $paymethod_2 = $postData['payment_method2'] ?? null;
    $amount2 = $postData['paid_amount2'] ?? 0;

    mysqli_autocommit($conn, false);
    $transactionSuccess = true;
    $errorMessage = '';

    try {
        $remainingQuantity = [];
        $cartDetails = [];
        $total = 0;

        foreach ($_SESSION['cart'] as $item) {
            $itemName = $item['name'];
            $productid = $item['id'];
            $itemQuantity = floatval($item['qty']);
            $subtotal = floatval($item['price']) * $itemQuantity;
            $itemIdentifier = $productid;

            if (!isset($remainingQuantity[$itemIdentifier])) {
                $remainingQuantity[$itemIdentifier] = 0;
            }

            $cartDetails[] = [
                'name' => $itemName,
                'id' => $productid,
                'price' => floatval($item['price']),
                'qty' => floatval($itemQuantity),
                'subtotal' => $subtotal,
            ];

            $remainingQuantity[$itemIdentifier] += $itemQuantity;
            $total += $subtotal;
        }

        $amountToInsert = ($amount +  $amount2);

        $insertSaleTransactionQuery = "INSERT INTO transaction_receipts (phone_number, total, payment_method, seller_date, seller_name, amount_received) VALUES ('$phone', '$total', '$type', '$date', '$username', '$amountToInsert')";
        if (!mysqli_query($conn, $insertSaleTransactionQuery)) {
            throw new Exception("Error inserting sale transaction: " . mysqli_error($conn));
        }

        $stid = mysqli_insert_id($conn);

        $insertSalePaymentQuery = "INSERT INTO payments (payment_method, trans_id, amount) VALUES (?, ?, ?)";
        $stmt = mysqli_prepare($conn, $insertSalePaymentQuery);
        mysqli_stmt_bind_param($stmt, "sid", $method, $stid, $amount);
        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Error inserting payment details: " . mysqli_error($conn));
        }
        mysqli_stmt_close($stmt);

        if (!empty($paymethod_2) && $amount2 > 0) {
            $stmt = mysqli_prepare($conn, $insertSalePaymentQuery);
            mysqli_stmt_bind_param($stmt, "sid", $paymethod_2, $stid, $amount2);
            if (!mysqli_stmt_execute($stmt)) {
                throw new Exception("Error inserting secondary payment details: " . mysqli_error($conn));
            }
            mysqli_stmt_close($stmt);
        }

        foreach ($cartDetails as $cartItem) {
            $itemName = $cartItem['name'];
            $productId = $cartItem['id'];
            $itemQuantity = floatval($cartItem['qty']);
            $subtotal = floatval($cartItem['price']) * $itemQuantity;
            $price = floatval($cartItem['price']);

            $productName = '';
            $deductionAmount = 0;

            if (strpos($itemName, 'CHIPS') !== false) {
                $productName = 'potato';
                $deductionAmount = $itemQuantity * 600;
            } else if (strpos($itemName, 'FISH 250GM') !== false || strpos($itemName, 'FISH 400GM') !== false) {
                $productName = 'FISH ' . (strpos($itemName, '250GM') !== false ? '250GM' : '400GM');
                $deductionAmount = $itemQuantity;
            }

            if (!empty($productName)) {
                $sqlUpdateProduct = "UPDATE products SET shop_quantity = shop_quantity - ? WHERE product_name = ?";
                $stmt = mysqli_prepare($conn, $sqlUpdateProduct);
                mysqli_stmt_bind_param($stmt, "ds", $deductionAmount, $productName);

                if (!mysqli_stmt_execute($stmt)) {
                    throw new Exception("Error updating $productName inventory: " . mysqli_stmt_error($stmt));
                }
                mysqli_stmt_close($stmt);
            } else {
                $sqlUpdateInventory = "UPDATE products SET shop_quantity = shop_quantity - ? WHERE product_id = ?";
                $stmt = mysqli_prepare($conn, $sqlUpdateInventory);
                mysqli_stmt_bind_param($stmt, "di", $itemQuantity, $productId);

                if (!mysqli_stmt_execute($stmt)) {
                    throw new Exception("Error updating inventory: " . mysqli_stmt_error($stmt));
                }
                mysqli_stmt_close($stmt);
            }

            $sqlInsertItemSales = "INSERT INTO sales (trans_id, product_name, product_id, quantity, selling_price, subtotal) VALUES ('$stid', '$itemName', '$productId', '$itemQuantity', '$price', '$subtotal')";
            if (!mysqli_query($conn, $sqlInsertItemSales)) {
                throw new Exception("Error inserting item sales: " . mysqli_error($conn));
            }
        }

        mysqli_commit($conn);
    } catch (Exception $e) {
        mysqli_rollback($conn);
        $transactionSuccess = false;
        $errorMessage = $e->getMessage();
    } finally {
        mysqli_autocommit($conn, true);
        mysqli_close($conn);
    }

    $responseData = [
        'success' => $transactionSuccess,
        'message' => $transactionSuccess ? 'Transaction successful!' : 'Transaction failed!',
        'error' => $errorMessage
    ];

    header('Content-Type: application/json');
    echo json_encode($responseData);
} else {
    header('HTTP/1.0 405 Method Not Allowed');
}
?>
