<?php
session_start();
include_once 'shikanisha.kts.php';

$response = []; // To store the response

// Check if the request is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $trans_id = $_POST['transid'] ?? null;
    $payamount = $_POST['payamount'] ?? 0;
    $paymethod = $_POST['paymethod'] ?? null;
    $payamount2 = $_POST['payamount2'] ?? 0;
    $paymethod2 = $_POST['paymethod2'] ?? null;
    $sellername = $_SESSION['user'] ?? 'DefaultUser';
    $date = date('Y-m-d');

    // Begin transaction
    $conn->begin_transaction();

    // Update transaction_receipts with the first payment
    $stmtUpdate = $conn->prepare("UPDATE `transaction_receipts` SET `amount_received` = `amount_received` + ?, `payment_method` = 'Paid' WHERE `trans_id` = ?");
    $stmtUpdate->bind_param("di", $payamount, $trans_id);

    if (!$stmtUpdate->execute()) {
        $response['status'] = 'error';
        $response['message'] = 'Error updating transaction receipts: ' . $stmtUpdate->error;
        $conn->rollback();
        echo json_encode($response);
        exit();
    }

    $stmtUpdate->close();

    // Insert first payment into payments table
    $stmtInsert = $conn->prepare("INSERT INTO `payments` (`payment_method`, `trans_id`, `amount`) VALUES (?, ?, ?)");
    $stmtInsert->bind_param("sid", $paymethod, $trans_id, $payamount);

    if (!$stmtInsert->execute()) {
        $response['status'] = 'error';
        $response['message'] = 'Error inserting first payment: ' . $stmtInsert->error;
        $conn->rollback();
        echo json_encode($response);
        exit();
    }

    // If there's a second payment, update and insert it
   // ... (previous code)

// Check if there's a second payment and insert if so
if ($payamount2 > 0 && $paymethod2) {
    // Prepare the update statement again for the second payment
    $stmtUpdate = $conn->prepare("UPDATE `transaction_receipts` SET `amount_received` = `amount_received` + ? WHERE `trans_id` = ?");
    $stmtUpdate->bind_param("di", $payamount2, $trans_id);
    if (!$stmtUpdate->execute()) {
        $response['status'] = 'error';
        $response['message'] = 'Error updating transaction receipts with second payment: ' . $stmtUpdate->error;
        $conn->rollback(); // Rollback the transaction
        echo json_encode($response);
        exit();
    }
    $stmtUpdate->close(); // Close the statement

    // Insert second payment into payments table
    $stmtInsert->bind_param("sid", $paymethod2, $trans_id, $payamount2);
    if (!$stmtInsert->execute()) {
        $response['status'] = 'error';
        $response['message'] = 'Error inserting second payment: ' . $stmtInsert->error;
        $conn->rollback(); // Rollback the transaction
        echo json_encode($response);
        exit();
    }
}

// ... (rest of the code)


    $stmtInsert->close();

    // Commit transaction
    $conn->commit();
    $response['status'] = 'success';
    $response['message'] = 'Payments updated successfully';
} else {
    $response['status'] = 'error';
    $response['message'] = 'Invalid request method.';
}

echo json_encode($response);
?>
