<?php
include_once 'shikanisha.kts.php';

// Calculate the start and end dates for the previous month
$startOfPreviousMonth = date('Y-m-01', strtotime('last month'));
$endOfPreviousMonth = date('Y-m-t', strtotime('last month'));

// Query to fetch sales data for the previous month
$sql = "SELECT 
    seller_name,
    SUM(amount_received) AS amount_collected,
    SUM(total) AS total_sales,
    SUM(total) - SUM(amount_received) AS debt
FROM 
    transaction_receipts
WHERE 
    seller_date >= ? AND seller_date <= ?
GROUP BY 
    seller_name";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $startOfPreviousMonth, $endOfPreviousMonth);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $statusBadge = '';
    if ($row['amount_collected'] == $row['total_sales']) {
        $statusBadge = '<span class="badge badge-success">Paid</span>';
    } elseif ($row['amount_collected'] < $row['total_sales']) {
        $statusBadge = '<span class="badge badge-warning">Pending</span>';
    } elseif ($row['amount_collected'] > $row['total_sales']) {
        $statusBadge = '<span class="badge badge-danger">Overpayment</span>';
    }

    $data[] = [
        'seller_name' => $row['seller_name'],
        'total_sales' => $row['total_sales'],
        'amount_collected' => $row['amount_collected'],
        'debt' => $row['debt'],
        'status' => $statusBadge, // This will be raw HTML for the badge
    ];
}

// Return the data as JSON
header('Content-Type: application/json');
echo json_encode(['data' => $data]);
?>
