<?php
session_start();
require_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Extract form data
    $expenseType = $_POST['expense_type'];
    $amount = $_POST['amount'];

    // Insert expense into database with current date and time
    $sql = "INSERT INTO expenses (expense_name, expense_amount, date_incurred) VALUES (?, ?, NOW())";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('si', $expenseType, $amount);
    
    $response = ['status' => 'error', 'message' => 'Failed to submit expense'];
    if ($stmt->execute()) {
        $response = ['status' => 'success', 'message' => 'Expense updated successfully'];
    }
    
    echo json_encode($response);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>
