<?php
// establish database connection
include_once 'shikanisha.kts.php';

// Check if the connection is successful
if ($conn->connect_error) {
    $response = array(
        'status' => 'error',
        'message' => 'Connection failed: ' . $conn->connect_error
    );
    echo json_encode($response);
    exit();
}

// Process form data
if(isset($_POST['vendorId']) && isset($_POST['paymentAmount']) && isset($_POST['paymentType'])) {
    $vendor_id = $_POST['vendorId'];
    $payment_amount = $_POST['paymentAmount'];
    $payment_type = $_POST['paymentType'];

    // Retrieve current amount owed for vendor
    $sql = "SELECT amount_owed FROM vendor_debts WHERE vendor_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $vendor_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $current_amount_owed = $row['amount_owed'];
    } else {
        $response = array(
            'status' => 'error',
            'message' => 'Vendor debt not found'
        );
        echo json_encode($response);
        exit();
    }

    // Calculate new amount owed based on payment type
    if($payment_type == "credit") {
        $new_amount_owed = $current_amount_owed + $payment_amount;
        $transaction_type = "Credit";
    } elseif($payment_type == "debit") {
        $new_amount_owed = $current_amount_owed - $payment_amount;
        $transaction_type = "Debit";
    } else {
        $response = array(
            'status' => 'error',
            'message' => 'Invalid payment type'
        );
        echo json_encode($response);
        exit();
    }

    // Update vendor_debts table with new amount owed
    $sql_update_debt = "UPDATE vendor_debts SET amount_owed = ? WHERE vendor_id = ?";
    $stmt_update_debt = $conn->prepare($sql_update_debt);
    $stmt_update_debt->bind_param("di", $new_amount_owed, $vendor_id);

    if ($stmt_update_debt->execute() === TRUE) {
        $date = date('Y-m-d');
        // Insert transaction record into vendor_transactions table
        $sql_insert_transaction = "INSERT INTO vendor_transactions (vendor_id, amount_transacted, transaction_type, date) VALUES (?, ?, ?, ?)";
        $stmt_insert_transaction = $conn->prepare($sql_insert_transaction);
        $stmt_insert_transaction->bind_param("idss", $vendor_id, $payment_amount, $transaction_type, $date);

        if ($stmt_insert_transaction->execute() === TRUE) {
            $response = array(
                'status' => 'success',
                'message' => 'Payment processed successfully'
            );
            echo json_encode($response);
        } else {
            $response = array(
                'status' => 'error',
                'message' => 'Error inserting transaction record: ' . $conn->error
            );
            echo json_encode($response);
        }
    } else {
        $response = array(
            'status' => 'error',
            'message' => 'Error updating record: ' . $conn->error
        );
        echo json_encode($response);
    }

    // Close prepared statements
    $stmt->close();
    $stmt_update_debt->close();
    $stmt_insert_transaction->close();
} else {
    $response = array(
        'status' => 'error',
        'message' => 'Invalid form data'
    );
    echo json_encode($response);
}
// Close connection
$conn->close();
?>
