<?php
// Include shikanisha.kts.php file
require 'shikanisha.kts.php';

// Check if the search query is set
if(isset($_POST['searchQuery'])) {
    // Sanitize the search query to prevent SQL injection
    $searchQuery = mysqli_real_escape_string($conn, $_POST['searchQuery']);
    
    // Perform the database query
    $sql = "SELECT `product_id`, `product_name`, `selling_price`, `food_group` FROM `products` WHERE `product_name` LIKE '%$searchQuery%' AND food_group != 'Product'";
    $result = mysqli_query($conn, $sql);

    // Check if there are any results
    if(mysqli_num_rows($result) > 0) {
        // Output data of each row
        echo '<table class="table">';
        echo '<thead><tr><th>Item Name</th><th>Selling Price</th><th>Action</th></tr></thead>';
        echo '<tbody>';
        while($row = mysqli_fetch_assoc($result)) {
            echo '<tr>';
            echo '<td>' . $row['product_name'] . '</td>';
            echo '<td>' . $row['selling_price'] . '</td>';
            echo '<td><button class="btn btn-primary add-to-cart-btn" data-food-id="' . $row['product_id'] . '" data-food-name="' . $row['product_name'] . '" data-food-price="' . $row['selling_price'] . '"><i class="fas fa-shopping-cart"></i></button></td>';
            echo '</tr>';
        }
        echo '</tbody>';
        echo '</table>';
    } else {
        echo 'No results found';
    }
} else {
    echo 'Search query not provided';
}

// Close the database connection
mysqli_close($conn);
?>
