<?php
// Include your database connection code here, and ensure $conn is defined.
include_once 'shikanisha.kts.php';


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $response = array();

    // Execute the SQL query
    $sql = "SELECT p.payment_method, SUM(p.amount) AS tills
FROM payments AS p
JOIN transaction_receipts AS tr ON p.trans_id = tr.trans_id
WHERE DATE(tr.seller_date) BETWEEN DATE_SUB(CURDATE(), INTERVAL DAYOFWEEK(CURDATE()) - 1 DAY) AND DATE_ADD(CURDATE(), INTERVAL 7 - DAYOFWEEK(CURDATE()) DAY)
GROUP BY p.payment_method;
";
    $result = mysqli_query($conn, $sql);

    if ($result) {
        $response['success'] = true;
        $reportData = '';
        $weeklyTotal = 0;

        while ($row = mysqli_fetch_assoc($result)) {
            $reportData .= '<tr>
                <td>' . $row['payment_method'] . '</td>
                <td>' . $row['tills'] . '</td>
            </tr>';
            $weeklyTotal += $row['tills'];
        }

        $response['reportData'] = $reportData;
        $response['weeklyTotal'] = $weeklyTotal;
    } else {
        $response['success'] = false;
        $response['message'] = 'Error executing the SQL query.';
    }

    // Return the response as JSON
    header('Content-type: application/json');
    echo json_encode($response);
} else {
    // Handle non-POST requests
    // You may return an error response or redirect to another page
}
?>
