<?php
session_start();
// check if the user is authorized to update the booking
if (isset($_SESSION['type']) && $_SESSION['type'] == 'Manager') {
    // check if the booking id is provided in the URL
    if (isset($_GET['id'])) {
        $booking_id = $_GET['id'];
        $timezone = new DateTimeZone('Africa/Nairobi');
        $date = (new DateTime('now', $timezone))->format('Y-m-d H:i:s');
        $status='checked_out';

        // connect to the database
        require_once('shikanisha.kts.php');
        if ($conn->connect_error) {
            die('Connection failed: ' . $conn->connect_error);
        }
        // prepare the update statement
        $stmt = $conn->prepare("UPDATE bookings SET  check_out_date=?,  status=? WHERE booking_id = ?");
        if (!$stmt) {
            die('Error preparing statement: ' . $conn->error);
        }
        $stmt->bind_param('ssi',  $date,  $status, $booking_id);
        // execute the statement
        if ($stmt->execute()) {
            // redirect to the bookings page with success message
            header('Location: ../accomodation.php');
            exit();
        } else {
            echo "Error updating booking: " . $stmt->error;
        }
        // close the statement
        $stmt->close();
        // close the connection
        $conn->close();
    } else {
        echo "Booking id not provided";
    }
} else {
    echo "Unauthorized access";
}
?>
