<?php 
session_start();
require_once "shikanisha.kts.php";

$response = [];

if (mysqli_connect_error()) {
    $response = [
        'status' => 'error',
        'message' => 'Cannot connect to database'
    ];
    echo json_encode($response);
    exit(); // Stop script execution if database connection fails
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    date_default_timezone_set('Africa/Nairobi');

    $seller = $_SESSION['user'];
    $date = date("Y-m-d H:i:s"); 
    // Generate a random order code
    $order_code = bin2hex(random_bytes(8));
    $status = 'Pending';

    $conn->begin_transaction(); // Start transaction

    $query1 = "INSERT INTO orders (code, order_date, order_by, status) VALUES (?, ?, ?, ?)";
    $stmt1 = mysqli_prepare($conn, $query1);
    mysqli_stmt_bind_param($stmt1, 'ssss', $order_code, $date, $seller, $status);
    $execute1 = mysqli_stmt_execute($stmt1);
    $order_id = mysqli_insert_id($conn);
    mysqli_stmt_close($stmt1);

    if ($execute1) {
        $all_items_inserted = true;
        $query2 = "INSERT INTO orderlist (product_name, quantity, product_id, order_id) VALUES (?, ?, ?, ?)";
        $stmt2 = mysqli_prepare($conn, $query2);
        mysqli_stmt_bind_param($stmt2, "sddd", $name, $quantity, $id, $order_id);

        foreach ($_SESSION['items-order'] as $value) {
            $name = $value['name'];
            $quantity = floatval($value['qty']);
            $id = $value['id'];
            if (!mysqli_stmt_execute($stmt2)) {
                $all_items_inserted = false;
                $response['message'] = 'Error inserting item: ' . mysqli_stmt_error($stmt2);
                break; // Exit the loop if insertion fails
            }
        }
        mysqli_stmt_close($stmt2);

        if ($all_items_inserted) {
            $conn->commit(); // Commit the transaction if all went well
            // Clear the session cart data
            unset($_SESSION['items-order']);
            $response = [
                'status' => 'success',
                'message' => 'Order List created successfully.'
                
            ];
        } else {
            $conn->rollback(); // Rollback the transaction if any insertions failed
        }
    } else {
        $response = [
            'status' => 'error',
            'message' => 'An error occurred while creating the order.'
        ];
    }
    echo json_encode($response);
    
}

?>
