<?php
// Include your database connection code here, and ensure $conn is defined.
include_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $response = array();

    // Set timezone to Africa/Nairobi
    date_default_timezone_set('Africa/Nairobi');

    // Execute the SQL query for the current day
    $sql = "SELECT 
                p.payment_method, 
                SUM(p.amount) AS tills,
                SUM(tr.total - tr.amount_received) AS debt
            FROM payments AS p
            JOIN transaction_receipts AS tr ON p.trans_id = tr.trans_id
            WHERE DATE(tr.seller_date) = CURDATE()
            GROUP BY p.payment_method";
    $result = mysqli_query($conn, $sql);

    if ($result) {
        $response['success'] = true;
        $reportData = '';
        $dailyTotalTills = 0;
        $dailyTotalDebt = 0;

        while ($row = mysqli_fetch_assoc($result)) {
            $reportData .= '<tr>
                <td>' . htmlspecialchars($row['payment_method']) . '</td>
                <td>' . htmlspecialchars($row['tills']) . '</td>
                <td>' . htmlspecialchars($row['debt']) . '</td>
            </tr>';
            $dailyTotalTills += $row['tills'];
            $dailyTotalDebt += $row['debt'];
        }

        $response['reportData'] = $reportData;
        $response['dailyTotalTills'] = $dailyTotalTills;
        $response['dailyTotalDebt'] = $dailyTotalDebt;
    } else {
        $response['success'] = false;
        $response['message'] = 'Error executing the SQL query: ' . mysqli_error($conn);
    }

    // Return the response as JSON
    header('Content-type: application/json');
    echo json_encode($response);
} else {
    // Handle non-POST requests
    // You may return an error response or redirect to another page
}
?>
