<?php
session_start();
include_once 'shikanisha.kts.php';

// Get the vendor transaction to be deleted
$transaction_id = $_POST['transaction_id'];

// Prepare and execute the query to select transaction details
$sql_select_transaction = "SELECT vendor_id, amount_transacted, transaction_type FROM vendor_transactions WHERE id = ?";
$stmt_select_transaction = $conn->prepare($sql_select_transaction);
$stmt_select_transaction->bind_param("i", $transaction_id);
$stmt_select_transaction->execute();
$result_transaction = $stmt_select_transaction->get_result();

if ($result_transaction->num_rows > 0) {
    $row = $result_transaction->fetch_assoc();
    $vendor_id = $row['vendor_id'];
    $amount_transacted = $row['amount_transacted'];
    $transaction_type = $row['transaction_type'];

    // Check if the transaction type is 'purchase'
    if ($transaction_type == "Purchase") {
        $response = array(
            'status' => 'error',
            'message' => 'Cannot delete purchase transaction.'
        );
        echo json_encode($response);
        exit();
    }

    // Delete the vendor transaction
    $sql_delete_transaction = "DELETE FROM vendor_transactions WHERE id = ?";
    $stmt_delete_transaction = $conn->prepare($sql_delete_transaction);
    $stmt_delete_transaction->bind_param("i", $transaction_id);
    if ($stmt_delete_transaction->execute() === FALSE) {
        $response = array(
            'status' => 'error',
            'message' => 'Error deleting transaction: ' . $conn->error
        );
        echo json_encode($response);
        exit();
    }

    // Update the vendor debt balance
    $sql_select_debt = "SELECT amount_owed FROM vendor_debts WHERE vendor_id = ?";
    $stmt_select_debt = $conn->prepare($sql_select_debt);
    $stmt_select_debt->bind_param("i", $vendor_id);
    $stmt_select_debt->execute();
    $result_debt = $stmt_select_debt->get_result();

    if ($result_debt->num_rows > 0) {
        $row_debt = $result_debt->fetch_assoc();
        $balance = $row_debt['amount_owed'];
        $new_balance = $balance + $amount_transacted;

        $sql_update_debt = "UPDATE vendor_debts SET amount_owed = ? WHERE vendor_id = ?";
        $stmt_update_debt = $conn->prepare($sql_update_debt);
        $stmt_update_debt->bind_param("di", $new_balance, $vendor_id);
        if ($stmt_update_debt->execute() === FALSE) {
            $response = array(
                'status' => 'error',
                'message' => 'Error updating vendor debt balance: ' . $conn->error
            );
            echo json_encode($response);
            exit();
        }
    } else {
        $response = array(
            'status' => 'error',
            'message' => 'No vendor debt found for vendor ID: ' . $vendor_id
        );
        echo json_encode($response);
        exit();
    }
    
    // Success message
    $response = array(
        'status' => 'success',
        'message' => 'Transaction successfully deleted.'
    );
    echo json_encode($response);
    exit();
} else {
    $response = array(
        'status' => 'error',
        'message' => 'No transaction found for ID: ' . $transaction_id
    );
    echo json_encode($response);
    exit();
}

// Close prepared statements and connection
$stmt_select_transaction->close();
$stmt_delete_transaction->close();
$stmt_select_debt->close();
$stmt_update_debt->close();
$conn->close();
?>
