<?php
session_start();
// Database connection
require_once 'shikanisha.kts.php';

// Check for the HTTP request method
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Assuming you have already connected to the database.

    // Add code to retrieve $customerId, $method, $descr, and $type from your form data.
    $postData = json_decode(file_get_contents("php://input"), true);

    // Retrieve the clientId from the received data
    $customerId = 1;
    $phone = $_SESSION['phone'];
    $method = 'To Pay';
    $amount = 0;
    $descr = ''; // Set a default value for $descr
    $type = 'Receipt'; // Set a default value for $type
    $username = $_SESSION['user'];
    $cash =  $postData['cash'];
    $date = $postData['date'];
  
    // Start a transaction
    mysqli_autocommit($conn, false); // Disable autocommit

    // Flag to track the success of the entire transaction
    $transactionSuccess = true;
    $errorMessage = ''; // Initialize an error message variable

    try {
        // Step 1: Initialize the remaining quantity to sell as the total quantity of items in the cart
        $remainingQuantity = [];
        $cartDetails = [];
        $total = 0;

        foreach ($_SESSION['cart'] as $item) {
            $itemName = $item['name'];
            $productid = $item['id'];
            $itemQuantity = floatval($item['qty']); // Convert quantity to integer
            $subtotal = floatval($item['price']) * $itemQuantity; // Calculate subtotal for each item

            // Create a unique identifier for the item based on name, attribute, and size
            $itemIdentifier = $productid;

            // If the unique identifier doesn't exist in $remainingQuantity, initialize it
            if (!isset($remainingQuantity[$itemIdentifier])) {
                $remainingQuantity[$itemIdentifier] = 0;
            }

            // Add the item's details, quantity, and subtotal to the $cartDetails array
            $cartDetails[] = [
                'name' => $itemName,
                'id' => $productid,
                'price' => floatval($item['price']), // Convert price to float
                'qty' => floatval($itemQuantity),
                'subtotal' => $subtotal,
            ];

            // Update the quantity for the unique identifier in $remainingQuantity
            $remainingQuantity[$itemIdentifier] += $itemQuantity;

            // Add the subtotal to the total
            $total += $subtotal;
        }

        // Determine the amount to insert
        $amountToInsert = ($amount > $total) ? $total : $amount;

        // Insert the sale transaction
        $insertSaleTransactionQuery = "INSERT INTO transaction_receipts (phone_number, total, payment_method, seller_date, seller_name, amount_received) VALUES ('$phone', '$total', '$method', '$date', '$username', '$amountToInsert')";
        if (!mysqli_query($conn, $insertSaleTransactionQuery)) {
            throw new Exception("Error inserting sale transaction: " . mysqli_error($conn));
        }

        // Get the last inserted sale_transaction ID
        $stid = mysqli_insert_id($conn);

        // Insert the sale payment details
        $insertSalePaymentQuery = "INSERT INTO payments (payment_method, trans_id, amount) VALUES ('$method', '$stid', '$amount')";
        if (!mysqli_query($conn, $insertSalePaymentQuery)) {
            throw new Exception("Error inserting Payment details: " . mysqli_error($conn));
        }

      

        // Insert into item_sales table and deduct inventory
// Insert into item_sales table and deduct inventory
foreach ($cartDetails as $cartItem) {
    $itemName = $cartItem['name'];
    $productId = $cartItem['id']; // Corrected variable name
    $itemQuantity = floatval($cartItem['qty']); // Corrected variable name
    $subtotal = floatval($cartItem['price']) * $itemQuantity;
    $price = floatval($cartItem['price']); // Corrected variable name

    // Define the product_name and deductionAmount based on the item name
    $productName = '';
    $deductionAmount = 0;

    if (strpos($itemName, 'CHIPS') !== false) {
        $productName = 'potato';
        $deductionAmount = $itemQuantity * 600;
    } else if (strpos($itemName, 'FISH 250GM') !== false || strpos($itemName, 'FISH 400GM') !== false) {
        $productName = 'FISH ' . (strpos($itemName, '250GM') !== false ? '250GM' : '400GM');
        $deductionAmount = $itemQuantity;
    }

    // Deduct the sold quantity from the specified product if applicable
    if (!empty($productName)) {
        $sqlUpdateProduct = "UPDATE products 
                            SET shop_quantity = shop_quantity - ? 
                            WHERE product_name = ?";

        $stmt = mysqli_prepare($conn, $sqlUpdateProduct);
        mysqli_stmt_bind_param($stmt, "ds", $deductionAmount, $productName);

        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Error updating $productName inventory: " . mysqli_stmt_error($stmt));
        }

        mysqli_stmt_close($stmt);
    } else {
        // Deduct the sold quantity from this batch for other products
        $sqlUpdateInventory = "UPDATE products 
                              SET shop_quantity = shop_quantity - ? 
                              WHERE product_id = ?";

        $stmt = mysqli_prepare($conn, $sqlUpdateInventory);
        mysqli_stmt_bind_param($stmt, "di", $itemQuantity, $productId); // Corrected variable name

        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Error updating inventory: " . mysqli_stmt_error($stmt));
        }

        mysqli_stmt_close($stmt);
    }

    // Insert a sales record into item_sales table
    $sqlInsertItemSales = "INSERT INTO sales 
                          (trans_id, product_name, product_id, quantity, selling_price, subtotal) 
                          VALUES ('$stid', '$itemName', '$productId', '$itemQuantity', '$price', '$subtotal')";

    if (!mysqli_query($conn, $sqlInsertItemSales)) {
        throw new Exception("Error inserting item sales: " . mysqli_error($conn));
    }
}

        // Commit the transaction if all queries were successful
        mysqli_commit($conn);
    } catch (Exception $e) {
        // Something went wrong, rollback the transaction
        mysqli_rollback($conn);
        $transactionSuccess = false;
        $errorMessage = $e->getMessage();
    } finally {
        // Re-enable autocommit and close the database connection
        mysqli_autocommit($conn, true); // Re-enable autocommit
        mysqli_close($conn);
    }

    // Prepare the response data
    $responseData = [
        'success' => $transactionSuccess,
        'message' => $transactionSuccess ? 'Transaction successful!' : 'Transaction failed!',
        'error' => $errorMessage
    ];

    // Send the JSON response back to the client
    header('Content-Type: application/json');
    echo json_encode($responseData);
} else {
    // Invalid request method
    header('HTTP/1.0 405 Method Not Allowed');
}
?>
