<?php
// Start or resume the PHP session
session_start();

// Connection info
// Step 1: Connect to the MySQL database
require_once('shikanisha.kts.php');

// Connect to the database
$mysqli = new mysqli($host, $username, $password, $database);

// Check for connection errors
if ($mysqli->connect_errno) {
    $response = [
        'status' => 'error',
        'message' => 'Failed to connect to MySQL: ' . $mysqli->connect_error
    ];
    echo json_encode($response);
    exit();
}

// Get the order ID from the POST request
$order_id = $_POST['order_id'];

// Prepare a query to update the order status
$sql = "UPDATE orders SET status = 'Updated' WHERE order_id = ?";
$stmt = $mysqli->prepare($sql);
if (!$stmt) {
    $response = [
        'status' => 'error',
        'message' => 'Failed to prepare statement: ' . $mysqli->error
    ];
    echo json_encode($response);
    exit();
}

// Bind parameters and execute the query
$stmt->bind_param("i", $order_id);
if (!$stmt->execute()) {
    $response = [
        'status' => 'error',
        'message' => 'Failed to update order status: ' . $stmt->error
    ];
    echo json_encode($response);
    exit();
}

// Close the statement and database connection
$stmt->close();
$mysqli->close();

// Send a success response
$response = [
    'status' => 'success',
    'message' => 'Order status updated successfully'
];
echo json_encode($response);
header("Location: ../create-order.php");

exit();
?>
