<?php
require_once('shikanisha.kts.php');

// Check if trans_id is provided
if(isset($_POST['trans_id'])) {
    // Get the transaction ID from the POST data
    $transId = $_POST['trans_id'];
    
    // Prepare and execute the query to select amount and client_id
    $selectQuery = "SELECT `amount`, `client_id` FROM `client_trans` WHERE `trans_id` = ?";
    $stmtSelect = $conn->prepare($selectQuery);
    $stmtSelect->bind_param("i", $transId);
    $stmtSelect->execute();
    $result = $stmtSelect->get_result();
    
    // Fetch the result
    $row = $result->fetch_assoc();
    $amount = $row['amount'];
    $clientId = $row['client_id'];
    
    // Update the amount owed
    $updateQuery = "UPDATE `client_acc` SET `amount_owed` = `amount_owed` + ? WHERE `client_id` = ?";
    $stmtUpdate = $conn->prepare($updateQuery);
    $stmtUpdate->bind_param("di", $amount, $clientId);
    $stmtUpdate->execute();
    
    // Delete the payment transaction
    $deleteQuery = "DELETE FROM `client_trans` WHERE `trans_id` = ?";
    $stmtDelete = $conn->prepare($deleteQuery);
    $stmtDelete->bind_param("i", $transId);
    $stmtDelete->execute();
    
    // Check if the transaction was deleted successfully
    if($stmtDelete->affected_rows > 0) {
        // Transaction was deleted successfully
        $response = array(
            'success' => true,
            'message' => 'Transaction deleted successfully.'
        );
    } else {
        // Transaction could not be deleted
        $response = array(
            'success' => false,
            'message' => 'Failed to delete transaction.'
        );
    }
} else {
    // trans_id not provided
    $response = array(
        'success' => false,
        'message' => 'Transaction ID not provided.'
    );
}

// Send JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>
