<?php
// Include database connection or any necessary dependencies
include_once 'shikanisha.kts.php';

// Check if invo_id is set in the GET request
if(isset($_GET['invo_id'])) {
    // Get the invo_id from the GET request
    $invo_id = $_GET['invo_id'];

    // Prepare and execute the query to fetch invoice details based on invo_id
    $sql = "SELECT * FROM purchase_orders WHERE invo_id = ?";
    $stmt = $conn->prepare($sql);

    // Check if the prepare() call was successful
    if ($stmt) {
        $stmt->bind_param("i", $invo_id);
        $stmt->execute();
        
        // Get result set
        $result = $stmt->get_result();

        // Initialize an array to store invoice details
        $invoiceDetails = array();

        // Fetch the results and store them in the array
        while ($row = $result->fetch_assoc()) {
            $invoiceDetails[] = array(
                'product_name' => $row['productname'],
                'price' => $row['price'],
                'quantity' => $row['quantity'],
                'subtotal' => $row['subtotal']
            );
        }

        // Close the statement
        $stmt->close();

        // Send the JSON response with invoice details
        header('Content-Type: application/json');
        echo json_encode($invoiceDetails);
    } else {
        // If prepare() fails, return an error message
        echo json_encode(array('error' => 'Prepare statement failed'));
    }
} else {
    // If invo_id is not set, return an error message
    echo json_encode(array('error' => 'No invo_id provided'));
}
?>
