<?php
    include 'shikanisha.kts.php'; // Include your database connection file

    $sql = "SELECT 
        amount_received, 
        payment_method, 
        phone_number, 
        seller_date, 
        seller_name, 
        total, 
        trans_id,
        type,
        table_name
    FROM 
        transaction_receipts
    WHERE 
        amount_received < total AND type = 'Receipt'
    ORDER BY 
        trans_id ASC";

    $result = mysqli_query($conn, $sql);

    $data = array();
    while($row = mysqli_fetch_array($result)){
        $status = '';
        if ($row['amount_received'] == $row['total']) {
            $status = 'Paid';
        } else if ($row['amount_received'] < $row['total']) {
            $status = 'Pending';
        } else if ($row['amount_received'] > $row['total']) {
            $status = 'Overpayment';
        }
        
        $data[] = array(
            "trans_id" => $row['trans_id'],
            "seller_name" => $row['seller_name'],
            "total" => $row['total'],
            "amount_received" => $row['amount_received'],
            "status" => $status,
            "table_name" => $row['table_name'],
            "seller_date" => $row['seller_date']
        );
    }

    echo json_encode(array("data" => $data));
?>
