<?php
// Include your database connection code here
require 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get form data
    $productid = $_POST['product_idd'];
    $startl = $_POST['startl'];
    $endl = $_POST['endl'];

    // Prepare SQL query
    $sql = "SELECT s.product_id,s.trans_id, p.product_name, s.selling_price AS price, s.quantity, s.subtotal, t.seller_date
            FROM sales s
            INNER JOIN products p ON s.product_id = p.product_id
            INNER JOIN transaction_receipts t ON s.trans_id = t.trans_id
            WHERE p.product_id LIKE ? AND t.seller_date BETWEEN ? AND ?";
    
    // Use prepared statements to avoid SQL injection
    $stmt = $conn->prepare($sql);
    
    // Bind parameters
    $stmt->bind_param("iss", $productid, $startl, $endl);

    // Execute query
    $stmt->execute();

    // Get result
    $result = $stmt->get_result();

    // Fetch data into an associative array
    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    // Close statement
    $stmt->close();

    // Return data as JSON
    echo json_encode($data);
} else {
    echo json_encode(['error' => 'Invalid request']);
}
?>
