<?php
include_once 'shikanisha.kts.php';

// Initialize the response array
$response = array();

// Get the data from the AJAX request
$product_name = $_POST['product-name-input'];
$company = $_POST['vendor'];
$buying_price = $_POST['buying-price-input'];
$selling_price = $_POST['selling-price-input'];
$store_qty =  0;
$shop_qty = 0;
$qty = floatval($_POST['new-quantity-input']);
$product_id = $_POST['product-id-input'];
$id = $_POST['codez'];
$reorderqty = $_POST['reorder-quantity-input'];
$transaction_type = "Debit";
$date = date('Y-m-d');

// Generate a random invoice number
$invoiceNumber = rand(100000, 999999);

// Calculate quantity and subtotal
$quantity = $store_qty + $shop_qty;
$subtotal = $qty * $buying_price;

// Update the product
$update_sql = "UPDATE products SET product_name=?, company=?, buying_price=?, selling_price=?,reorder_qty=?, store_quantity=store_quantity+?, shop_quantity=shop_quantity+CAST(? AS DECIMAL(10,2)) WHERE product_id=?";
$update_stmt = $conn->prepare($update_sql);
$update_stmt->bind_param("ssddiddi", $product_name, $company, $buying_price, $selling_price, $reorderqty, $store_qty, $qty, $product_id);
$update_result = $update_stmt->execute();
// If quantity is not greater than 0, end the code here
if ($qty <= 0) {
    $response['status'] = 'success';
    $response['message'] = 'Update successful.';
    // Send the JSON response and exit
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// Insert into invoice table
$purchase_sql = "INSERT INTO invoice (invoice_number, date, total, supplier_name) VALUES (?, ?, ?, ?)";
$purchase_stmt = $conn->prepare($purchase_sql);
$purchase_stmt->bind_param("ssds", $invoiceNumber, $date, $subtotal, $company);
$purchase_result = $purchase_stmt->execute();

if (!$purchase_result) {
    $response['status'] = 'error';
    $response['message'] = 'Invoice insertion failed.';
    // Send the JSON response and exit
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// Get the last inserted invoice ID
$invoice_id = $conn->insert_id;

// Insert into purchases table
if ($update_result) {
    $purchase_date = date('Y-m-d');
    $purchase_sql = "INSERT INTO purchase_orders (productname, price, quantity, subtotal, invo_id) VALUES (?, ?, ?, ?, ?)";
    $purchase_stmt = $conn->prepare($purchase_sql);
    $purchase_stmt->bind_param("sddds", $product_name, $buying_price, $qty, $subtotal, $invoice_id);
    $purchase_result = $purchase_stmt->execute();

    if ($purchase_result) {
        // Update vendor debts and add vendor transaction
        $transaction_type = "Purchase";
        $date = date('Y-m-d');
        $sql = "SELECT amount_owed FROM vendor_debts WHERE vendor_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $current_amount_owed = $row['amount_owed'];
            $new_amount_owed = $current_amount_owed + $subtotal;
            $sql = "UPDATE vendor_debts SET amount_owed = ? WHERE vendor_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("di", $new_amount_owed, $id);

            if ($stmt->execute()) {
                $sql = "INSERT INTO vendor_transactions (vendor_id, amount_transacted, transaction_type, date) VALUES (?, ?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("idss", $id, $subtotal, $transaction_type, $date);

                if ($stmt->execute()) {
                    // Success response
                    $response['status'] = 'success';
                    $response['message'] = 'Product updated and added to purchases successfully. Payment processed successfully.';
                } else {
                    $response['status'] = 'error';
                    $response['message'] = 'Vendor transaction not added successfully';
                }
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Vendor debt not updated successfully';
            }
        } else {
            $response['status'] = 'error';
            $response['message'] = 'No vendor debt found';
        }
    } else {
        $response['status'] = 'error';
        $response['message'] = 'Product update successful, but record not added to purchases table';
    }
} else {
    $response['status'] = 'error';
    $response['message'] = 'Product update failed';
}

// Close statements and connection
$update_stmt->close();
$purchase_stmt->close();
$conn->close();

// Send the JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>
