<?php
include_once 'shikanisha.kts.php';

// Get the data from the AJAX request
$product_name = $_POST['product-name-input'];
$company = $_POST['company'];
$buying_price = $_POST['buying-price-input'];
$selling_price = $_POST['selling-price-input'];
$store_qty =  0;
$shop_qty = !empty($_POST['new-quantity-input']) ? floatval($_POST['new-quantity-input']) : 0;$product_id = $_POST['product-id-input'];
$id = $_POST['id'];
$transaction_type = "Debit";
$date = date('Y-m-d');

// Calculate quantity and subtotal
$quantity = $store_qty + $shop_qty;
$subtotal = $quantity * $buying_price;

// Update the product
// Update the product
$update_sql = "UPDATE products SET product_name=?, company=?, buying_price=?, selling_price=?, store_quantity=store_quantity+?, shop_quantity=shop_quantity+CAST(? AS DECIMAL(10,2)) WHERE product_id=?";
$update_stmt = $conn->prepare($update_sql);
$update_stmt->bind_param("ssddisi", $product_name, $company, $buying_price, $selling_price, $store_qty, $shop_qty, $product_id);
$update_result = $update_stmt->execute();


// Insert into purchases table if the update was successful
if ($update_result) {
    $purchase_date = date('Y-m-d');
    $purchase_sql = "INSERT INTO purchase_orders (purchase_date, productname, price, quantity, subtotal, company) VALUES (?, ?, ?, ?, ?, ?)";
    $purchase_stmt = $conn->prepare($purchase_sql);
    $purchase_stmt->bind_param("ssddss", $purchase_date, $product_name, $buying_price, $quantity, $subtotal, $company);
    $purchase_result = $purchase_stmt->execute();

    if ($purchase_result) {
        echo "Product updated and added to purchases successfully";
        
        // Update vendor debts and add vendor transaction
        $transaction_type = "Purchase";
        $date = date('Y-m-d');
        $sql = "SELECT amount_owed FROM vendor_debts WHERE vendor_id = '$id'";
        $result = $conn->query($sql);
        
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $current_amount_owed = $row['amount_owed'];
            $new_amount_owed = $current_amount_owed + $subtotal;
            $sql = "UPDATE vendor_debts SET amount_owed = '$new_amount_owed' WHERE vendor_id = '$id'";
            
            if ($conn->query($sql) === TRUE) {
                $sql = "INSERT INTO vendor_transactions (vendor_id, amount_transacted, transaction_type, date) VALUES ('$id', '$subtotal', '$transaction_type', '$date')";
                
                if ($conn->query($sql) === TRUE) {
                    echo "Payment processed successfully";
                } else {
                    echo "Vendor transaction not added successfully";
                }
            } else {
                echo "Vendor debt not updated successfully";
            }
        } else {
            echo "No vendor debt found";
        }
    } else {
        echo "Product update successful, but record not added to purchases table";
    }
} else {
    echo "Product update failed";
}

$update_stmt->close();
$purchase_stmt->close();
$conn->close();
?>
