<?php
// Start or resume the PHP session
session_start();

// Include the database connection file
require_once 'shikanisha.kts.php';

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Extract the email and new password from the form data
    $email = $_POST['email'];
    $newPassword = $_POST['password1'];

    // Hash the new password before updating
    $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

    // Update the password in the database
    $sql = "UPDATE employees SET password = ? WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $hashedPassword, $email); // Use $hashedPassword instead of $newPassword

    // Execute the update statement
    if ($stmt->execute()) {
        // Password update successful
        echo json_encode(['status' => 'success']);
    } else {
        // Password update failed
        echo json_encode(['status' => 'error']);
    }
} else {
    // If the request method is not POST, return an error
    echo json_encode(['status' => 'error']);
}
?>
