<?php
// Include your database connection code here
require 'shikanisha.kts.php';

// Get the product name from the POST request
if (isset($_POST['productname'])) {
    $productName = $_POST['productname'];

    // Prepare the SQL statement to search for products
    $sql = "SELECT `product_id`, `product_name` FROM `products` WHERE `product_name` LIKE ?";

    $stmt = $conn->prepare($sql);
    if ($stmt) {
        // Bind the parameter
        $param = '%' . $productName . '%';
        $stmt->bind_param("s", $param);

        // Execute the statement
        $stmt->execute();

        // Get result set
        $result = $stmt->get_result();

        // Fetch data and store in an array
        $products = [];
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;
        }

        // Close the statement
        $stmt->close();

        // Return the products as JSON
        echo json_encode($products);
    } else {
        // Handle the error
        echo json_encode(['error' => "Prepare failed: (" . $conn->errno . ") " . $conn->error]);
    }
} else {
    // Return an error if productname is not set
    echo json_encode(['error' => 'Product name not provided']);
}

// Close the database connection
$conn->close();
?>