<?php
// Include your database connection code here, and ensure $conn is defined.
include_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $response = array();

    // Extract data from the POST request
    $employeeId = $_POST['empid'];
    $newSalary = $_POST['salary'];
    $newRegistrationDate = $_POST['regdate'];
    $newPosition = $_POST['type'];

    // Validate the data if needed

    // Update the employee salary in the database
    $sql = "UPDATE employees SET salary_amount = ?, type=?, registration_date = ? WHERE employee_id = ?";
    $stmt = mysqli_prepare($conn, $sql);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "dsss", $newSalary, $newPosition, $newRegistrationDate, $employeeId);
        $result = mysqli_stmt_execute($stmt);

        if ($result) {
            $response['success'] = true;
            $response['message'] = 'Employee salary updated successfully!';
        } else {
            $response['success'] = false;
            $response['message'] = 'Error updating employee salary.';
        }

        mysqli_stmt_close($stmt);
    } else {
        $response['success'] = false;
        $response['message'] = 'Error preparing SQL statement.';
    }

    // Return the response as JSON
    header('Content-type: application/json');
    echo json_encode($response);
} else {
    // Handle non-POST requests
    // You may return an error response or redirect to another page
    $response['success'] = false;
    $response['message'] = 'Invalid request method.';
    header('Content-type: application/json');
    echo json_encode($response);
}
?>
