<?php
// Start or resume the PHP session
session_start();
include_once 'shikanisha.kts.php';

$roomId = $_POST['roomId'];
$checkInDate = date("Y-m-d H:i:s", strtotime($_POST['checkInDate']));
$checkOutDate = date("Y-m-d H:i:s", strtotime($_POST['checkOutDate']));
$guest=$_POST['guestName'];
$username = $_SESSION['user'];

// check if room is available during selected dates
$sql = "SELECT * FROM bookings WHERE room_id = '$roomId' AND ((check_in_date <= '$checkInDate' AND check_out_date >= '$checkInDate') OR (check_in_date <= '$checkOutDate' AND check_out_date >= '$checkOutDate'))";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // room is not available, return error message
    echo "Sorry, the selected room is not available during the selected dates.";
} else {
    // room is available, book the room
    $userId = $_SESSION['userId'];
    $sql = "INSERT INTO bookings (room_id, user_name,guest, check_in_date, check_out_date) 
VALUES ('$roomId', '$username', '$guest', '$checkInDate 00:00:00', '$checkOutDate 00:00:00')";
    if ($conn->query($sql) === TRUE) {
        // booking successful, retrieve the order details and store them in the cart and total session variables
        $sql = "SELECT room_id, room_name, price FROM rooms WHERE room_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $roomId);
        $stmt->execute();
        $result = $stmt->get_result();
        $order_details = array();
        while ($row = $result->fetch_assoc()) {
            $order_details[] = array(
                'id'    =>  $row['room_id'],
                'name'  =>  $row['room_name'] . ' room',
                'price' =>  $row['price'],
                'qty'   =>  1
            );
        }
        $_SESSION['cart'] = $order_details;

        $stmt->close();

        $sql = "SELECT `price` FROM `rooms` WHERE `room_id` = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $roomId);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $_SESSION['total'] = $row['price'];
        } else {
            $_SESSION['error_message'] = "Could not retrieve order details";
            header("Location: ../accommodation.php");
            exit;
        }
        $stmt->close();

        $sql = "UPDATE rooms SET status = 2 WHERE room_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $roomId);
        $stmt->execute();
        if ($stmt->affected_rows > 0) {
            $_SESSION['success_message'] = "Room successfully occupied/booked.";
        } else {
            $_SESSION['error_message'] = "Failed to update room status for ID $roomId.";
        }
        $stmt->close();
        $conn->close();
        header("Location: ./trans.php");
        exit;
    } else {
        echo "Error: " . $sql . "<br>" . $conn->error;
    }
}
?>

 <div class="container-fluid mt-3">
          
              <div class="row">
                   
                    <div class="col-lg-12 col-sm-6">
                      <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Invoice Details</h4>
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered  table-sm purchase-table" id="bootstrap-data-table-export">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Product Name</th>
                                                <th>Vendor</th>
                                                <th>Buying Price</th>
                                                <th>Quantity</th>
                                                <th>Subtotal</th>
                                                <th>Date</th>
                                              
                                            </tr>
                                        </thead>
                                       <tbody></tbody>
                                        <tfoot>
                                            <tr>
                                                <th>#</th>
                                                <th>Product Name</th>
                                                <th>Vendor</th>
                                                <th>Buying Price</th>
                                                <th>Quantity</th>
                                                <th>Subtotal</th>
                                                <th>Date</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
               </div>
                </div>
               
