<?php
session_start();

// Assuming you have a database connection established
require_once('shikanisha.kts.php');

// Check if the product ID is provided
if (isset($_POST['productId'])) {
    $productId = $_POST['productId'];

    // Assuming your cart items are stored in the $_SESSION['cart'] array
    if (!empty($_SESSION['cart'])) {
        // Find the index of the item with the given product ID in the cart array
        $itemIndex = -1;
        foreach ($_SESSION['cart'] as $index => $item) {
            if ($item['product_id'] == $productId) {
                $itemIndex = $index;
                break;
            }
        }

        if ($itemIndex != -1) {
            // Remove the item from the cart
            unset($_SESSION['cart'][$itemIndex]);

            // Send a success response
            $response = ['success' => true, 'message' => 'Item removed successfully.'];
            header('Content-Type: application/json');
            echo json_encode($response);
            exit();
        }
    }
}

// If the script reaches here, something went wrong
$response = ['success' => false, 'message' => 'Failed to remove item.'];
header('Content-Type: application/json');
echo json_encode($response);
?>
