$('#bootstrap-data-table-export').DataTable({
    dom: 'lBfrtip',
    lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
    buttons: [
        {
            extend: 'copy',
            exportOptions: {
                columns: ':visible'
            },
            customize: function(doc) {
                var footer = $('<div>').append($('#row-select').DataTable().table().footer()).html();
                doc.content[1].table.footer = footer;
            }
        },
        {
            extend: 'csv',
            exportOptions: {
                columns: ':visible'
            },
            customize: function(doc) {
                var footer = $('<div>').append($('#row-select').DataTable().table().footer()).html();
                doc.footer = footer;
            }
        },
        {
            extend: 'excel',
            exportOptions: {
                columns: ':visible'
            },
            customize: function(xlsx) {
                var sheet = xlsx.xl.worksheets['sheet1.xml'];
                var footer = $('<div>').append($('#row-select').DataTable().table().footer()).html();
                $('row:last c', sheet).attr('s', '35');
                var colCount = $('row:last', sheet).children().length;
                $('row:last', sheet).after('<row><c s="35" t="inlineStr" colspan="' + colCount + '"><is><t>' + footer + '</t></is></c></row>');
            }
        },
        {
            extend: 'pdf',
            exportOptions: {
                columns: ':visible'
            },
            customize: function(doc) {
                var footer = $('<div>').append($('#row-select').DataTable().table().footer()).html();
                doc.content[1].table.footer = footer;
            }
        },
        {
            extend: 'print',
            exportOptions: {
                columns: ':visible'
            },
            customize: function(doc) {
                var footer = $('<div>').append($('#row-select').DataTable().table().footer()).html();
                $(doc.footer).html(footer);
            }
        }
    ]
});
