<?php
session_start();
$total = 0; // Initialize $total to 0

if (isset($_SESSION['order']) && !empty($_SESSION['order'])) {
    $output = '';

    foreach ($_SESSION['order'] as $key => $value) {
        $subtotal = $value['price'] * $value['qty'];
        $total += $subtotal;

        $output .= '<tr>
            <th>' . $value['id'] . '</th>
            <td>' . $value['name'] . '</td>
            <td>' . $value['price'] . '</td>
            <td>' . $value['qty'] . '</td>
            <td>' . $subtotal . '</td>
            <td>
                <a href="orders.php?action=remove&id=' . $value['id'] . '">
                    <button class="btn btn-danger btn-sm" type="button">Remove</button>
                </a>
            </td>
        </tr>';
    }
} else {
    $output = '<tr><td colspan="6">Your cart is empty</td></tr>';
}
?>

<!DOCTYPE html>
<html>
<head>
    <!-- Include your CSS and JavaScript libraries here -->
</head>
<body>
    <h4 class="card-title">Order List</h4>
    <div class="table-responsive">
        <table class="table table-striped table-bordered zero-configuration table-sm">
            <thead>
                <tr>
                    <th scope="col">Name</th>
                    <th scope="col">Product Name</th>
                    <th scope="col">Price</th>
                    <th scope="col">Quantity</th>
                    <th scope="col">Subtotal</th>
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php echo $output; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Total</th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"><?php echo number_format($total, 2); ?></th>
                    <th scope="col">
                        <a href="orders.php">
                            <button type="button" class="btn btn-warning btn-sm">Clear All</button>
                        </a>
                    </th>
                </tr>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col">
                        <button type="submit" id="trans" class="btn btn-secondary btn-sm">Submit</button>
                    </th>
                </tr>
            </tfoot>
        </table>
    </div>
   <script>
$(document).ready(function() {
    $('#trans').click(function() {
        // Serialize the form data
        var formData = $('#order-form').serialize();

        $.ajax({
            type: "POST",
            url: "./database/orders.kts.php",
            data: formData,
           success: function(response) {
    var data = JSON.parse(response); // Parse the JSON response
    if(data.status === 'success') {
        Swal.fire({
            icon: 'success',
            title: 'Success',
            text: data.message
        }).then(function() {
            window.location.href = data.redirect;
        });
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: data.message
        });
    }
},
            error: function(xhr, status, error) {
                // Handle any errors that occur during the AJAX request
                Swal.fire({
                    icon: 'error',
                    title: 'AJAX Error',
                    text: 'There was an error processing your request: ' + error,
                    showConfirmButton: true
                });
            }
        });
    });
}); 
</script>

</body>

</html>
