<?php
session_start();
require('./database/shikanisha.kts.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
 $id = isset($_POST['id']) ? $_POST['id'] : null;
    $name = isset($_POST['name']) ? $_POST['name'] : null;
    $price = isset($_POST['price']) ? $_POST['price'] : null;
    $qty = isset($_POST['qty']) ? $_POST['qty'] : null;

    // Check if store quantity is available before adding to cart
    $query_check = "SELECT shop_quantity FROM products WHERE product_id = ?";
    $stmt_check = mysqli_prepare($conn, $query_check);

    if ($stmt_check) {
        mysqli_stmt_bind_param($stmt_check, "i", $id);
        mysqli_stmt_execute($stmt_check);

        mysqli_stmt_bind_result($stmt_check, $store_quantity);
        mysqli_stmt_fetch($stmt_check);

        if ($store_quantity < $qty) {
            // Product is unavailable
            echo "failed"; // Return a failure message
        } else {
            // Product is available
            $products = array('id' => $id, 'name' => $name, 'price' => $price, 'qty' => $qty);

            // Initialize the session cart if not already set
            if (!isset($_SESSION['order'])) {
                $_SESSION['order'] = array();
            }

            // Check if the item already exists in the cart
            $existing_item_key = array_search($id, array_column($_SESSION['order'], 'id'));
            if ($existing_item_key !== false) {
                // If the item already exists in the cart, update its quantity
                $_SESSION['order'][$existing_item_key]['qty'] += $qty;
            } else {
                // Add a new item to the cart
                $_SESSION['order'][] = $products;
            }

            echo "success"; // Return a success message
        }

        mysqli_stmt_close($stmt_check);
    }
}
?>
