<?php
include_once 'shikanisha.kts.php'; // Path to your database connection script

// The SQL query to fetch all transactions
$sql = "SELECT trans_id, seller_name, total, amount_received, seller_date FROM transaction_receipts ORDER BY trans_id DESC";
$result = mysqli_query($conn, $sql);

// Initialize an array to hold the formatted data
$data = array();

while ($row = mysqli_fetch_assoc($result)) {
    $nestedData = array(); // An array for each row of the table

    $nestedData['trans_id'] = $row['trans_id'];
    $nestedData['seller_name'] = $row['seller_name'];
    $nestedData['total'] = $row['total'];
    $nestedData['amount_received'] = $row['amount_received'];
    $nestedData['seller_date'] = $row['seller_date'];

    // Determine the status based on the amount received
    if ($row['amount_received'] == $row['total']) {
        $nestedData['status'] = '<span class="badge badge-success">Paid</span>';
    } elseif ($row['amount_received'] < $row['total']) {
        $nestedData['status'] = '<span class="badge badge-warning">Pending</span>';
    } else {
        $nestedData['status'] = '<span class="badge badge-danger">Overpayment</span>';
    }

    // Create the action button (you need to define the 'viewOrderDet' JavaScript function)
    $nestedData['action'] = '<button class="btn btn-info" onclick="viewOrderDet(' . $row['trans_id'] . ')">View Details</button>';
    $nestedData['delete'] = '<button class="btn btn-danger" onclick="deleteOrderDet(' . $row['trans_id'] . ')">Delete Details</button>';

    $data[] = $nestedData; // Add the row to the main array
}

// Convert the data array to a JSON string
$json_data = json_encode($data);

// Return the JSON string
echo $json_data;
?>
