<?php
session_start();
require_once('shikanisha.kts.php'); // Replace with your database connection information

try {
    // Check the connection
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }

    $paymentMethod = $_POST['paymethod'];
    $paidAmount = $_POST['amount'];
    $ptotal = $_POST['ptotal'];
    $bill = $_POST['amount'];

    // Get cart items and quantities from the session
    $cartItems = $_SESSION['shopz'];
    $total = 0;

    // Start a database transaction
    $conn->begin_transaction();

    // Insert into shop_transaction
    $insertTransactionQuery = "INSERT INTO transaction_receipt (total, payment_method, amount_received, date,seller_name) VALUES (?, ?, ?, NOW())";
    $stmt = $conn->prepare($insertTransactionQuery);
    $stmt->bind_param("dsd", $ptotal, $paymentMethod, $ptotal);
    $stmt->execute();
    
    // Get the insert ID
    $insert_id = $stmt->insert_id;
    
    $stmt->close();
foreach ($cartDetails as $cartItem) {
    $itemName = $cartItem['name'];
    $productid = $cartItem['productid'];
    $itemQuantity = floatval($cartItem['quantity']);
    $subtotal = floatval($cartItem['price']) * $itemQuantity;
    $price = floatval($cartItem['price']);

    // Define the product_name and deductionAmount based on the item name
    $productName = '';
    $deductionAmount = 0;

    if (strpos($itemName, 'CHIPS') !== false) {
        $productName = 'potato';
        $deductionAmount = $itemQuantity * 600;
    } else if (strpos($itemName, 'FISH 250GM') !== false || strpos($itemName, 'FISH 400GM') !== false) {
        $productName = 'FISH ' . (strpos($itemName, '250GM') !== false ? '250GM' : '400GM');
        $deductionAmount = $itemQuantity;
    }

    // Deduct the sold quantity from the specified product if applicable
    if (!empty($productName)) {
        $sqlUpdateProduct = "UPDATE products 
                            SET shop_quantity = shop_quantity - ? 
                            WHERE product_name = ?";

        $stmt = mysqli_prepare($conn, $sqlUpdateProduct);
        mysqli_stmt_bind_param($stmt, "ds", $deductionAmount, $productName);

        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Error updating $productName inventory: " . mysqli_stmt_error($stmt));
        }

        mysqli_stmt_close($stmt);
    } else {
        // Deduct the sold quantity from this batch for other products
        $sqlUpdateInventory = "UPDATE products 
                              SET shop_quantity = shop_quantity - ? 
                              WHERE product_id = ?";

        $stmt = mysqli_prepare($conn, $sqlUpdateInventory);
        mysqli_stmt_bind_param($stmt, "di", $itemQuantity, $productid);

        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Error updating inventory: " . mysqli_stmt_error($stmt));
        }

        mysqli_stmt_close($stmt);
    }

    // Insert a sales record into item_sales table
    $sqlInsertItemSales = "INSERT INTO sales 
                          (trans_id, product_name, product_id, quantity, selling_price, subtotal) 
                          VALUES ('$stid', '$itemName', '$productid', '$itemQuantity', '$price', '$subtotal')";

    if (!mysqli_query($conn, $sqlInsertItemSales)) {
        throw new Exception("Error inserting item sales: " . mysqli_error($conn));
    }
}

    // Commit the transaction
    $conn->commit();

    // Calculate change
    $change = $paidAmount - $total;

    // Close the database connection
    $conn->close();

    // Store transaction data in a session variable
    $_SESSION['transaction'] = array(
        'paymentMethod' => $paymentMethod,
        'paidAmount' => $paidAmount,
        'change' => $change,
    );

    // Send a success response
    $response = array('success' => true);
} catch (Exception $e) {
    // Handle exceptions and log errors
    error_log("Exception: " . $e->getMessage());
    $response = array('success' => false, 'error' => $e->getMessage());
}


// Send a JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>
