<?php
include_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['trans_id'])) {
    $transId = $conn->real_escape_string($_POST['trans_id']);

    // Prepare data array to hold both payments and sales items
    $orderDetails = ['payments' => [], 'sales' => [], 'transaction_receipts' => []];
    
   // Fetch transaction receipts
    $receiptsSql = "SELECT amount_received, payment_method, phone_number, seller_date, seller_name, total, trans_id, table_name FROM transaction_receipts WHERE trans_id = ?";
    $receiptsStmt = $conn->prepare($receiptsSql);
    $receiptsStmt->bind_param("i", $transId);
    $receiptsStmt->execute();
    $receiptsResult = $receiptsStmt->get_result();
    while ($receiptRow = $receiptsResult->fetch_assoc()) {
        $orderDetails['transaction_receipts'][] = $receiptRow;
    }
    // Fetch payments
    $paymentsSql = "SELECT pay_id, payment_method, trans_id, amount FROM payments WHERE trans_id = ?";
    $paymentsStmt = $conn->prepare($paymentsSql);
    $paymentsStmt->bind_param("i", $transId);
    $paymentsStmt->execute();
    $paymentsResult = $paymentsStmt->get_result();
    while ($paymentRow = $paymentsResult->fetch_assoc()) {
        $orderDetails['payments'][] = $paymentRow;
    }

    // Fetch sales items
    $salesSql = "SELECT sale_id, product_id, product_name, quantity, selling_price, subtotal, trans_id FROM sales WHERE trans_id = ?";
    $salesStmt = $conn->prepare($salesSql);
    $salesStmt->bind_param("i", $transId);
    $salesStmt->execute();
    $salesResult = $salesStmt->get_result();
    while ($salesRow = $salesResult->fetch_assoc()) {
        $orderDetails['sales'][] = $salesRow;
    }

    echo json_encode($orderDetails);
} else {
    echo json_encode(['error' => 'Invalid request']);
}
?>
