<?php
session_start();
include_once 'shikanisha.kts.php';

header('Content-Type: application/json'); // Set header for JSON response

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['start_date']) && isset($_POST['end_date'])) {
    $start_date = $conn->real_escape_string($_POST['start_date']);
    $end_date = $conn->real_escape_string($_POST['end_date']);

    // Adjusted SQL query to join the products table and include the sum of amounts for each payment method
    $sql = "SELECT
        s.product_id,
        p.product_name,
        p.buying_price, 
        s.selling_price, 
        SUM(s.quantity) AS total_quantity,
        SUM(t.amount_received) AS total_amount_received,
        SUM(s.selling_price * s.quantity) AS total_selling
    FROM sales s
    INNER JOIN products p ON s.product_id = p.product_id
    INNER JOIN transaction_receipts t ON s.trans_id = t.trans_id
    WHERE t.seller_date BETWEEN ? AND ?
    GROUP BY s.product_id, p.product_name, p.buying_price, s.selling_price;
    ";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        // Handle error properly
        echo json_encode(['error' => "Prepare failed: (" . $conn->errno . ") " . $conn->error]);
        exit();
    }

    $stmt->bind_param("ss", $start_date, $end_date);
    $stmt->execute();
    $result = $stmt->get_result();

    $data = [];
    $total_selling = 0; // Initialize total selling
    while ($row = $result->fetch_assoc()) {
        // Add the row to the data array
        $data[] = $row;
        $total_selling += $row['total_selling'];
    }

    $stmt->close();

    // Calculate payment method and amount
    $sqlPayment = "SELECT p.payment_method, SUM(p.amount) AS total_amount
                    FROM payments AS p
                    JOIN transaction_receipts AS tr ON p.trans_id = tr.trans_id
                    WHERE tr.seller_date BETWEEN ? AND ?
                    GROUP BY p.payment_method;";

    $stmtPayment = $conn->prepare($sqlPayment);
    if (!$stmtPayment) {
        echo json_encode(['error' => "Prepare failed: (" . $conn->errno . ") " . $conn->error]);
        exit();
    }

    $stmtPayment->bind_param("ss", $start_date, $end_date);
    $stmtPayment->execute();
    $resultPayment = $stmtPayment->get_result();

    $paymentData = [];
    while ($rowPayment = $resultPayment->fetch_assoc()) {
        $paymentData[] = [
            'payment_method' => $rowPayment['payment_method'],
            'total_amount' => $rowPayment['total_amount']
        ];
    }

    $stmtPayment->close();

    // Add total selling, payment method, and payment amount to the response array
    $response = [
        'data' => $data,
        'total_selling' => $total_selling,
        'paymentMethod' => $paymentData,
    ];

    echo json_encode($response); // Return the data as JSON
} else {
    echo json_encode(['error' => 'Invalid request']); // Return error if conditions not met
}
?>
