<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payroll Calculator</title>
</head>

<body>

    <div>
        <label for="grossSalary">Enter Gross Salary: </label>
        <input type="number" id="grossSalary">
        <button onclick="calculateNetPay()">Calculate Net Pay</button>
    </div>

    <div id="results">
        <!-- Display results here -->
    </div>

    <script>
        function calculateNetPay() {
            // Get the input value
            const grossSalaryInput = document.getElementById('grossSalary');
            const grossPay = parseFloat(grossSalaryInput.value);

            // Validate input
            if (isNaN(grossPay)) {
                alert('Please enter a valid number for Gross Salary.');
                return;
            }

            // Calculate deductions and net pay
            const { nssfTier1, nssfTier2, nhif, housingLevy, payeBeforeRelief, dynamicRelief, payeAfterRelief, totalDeductions, netPay } = calculateDeductions(grossPay);

            // Display results
            displayResults(grossPay, nssfTier1, nssfTier2, nhif, housingLevy, payeBeforeRelief, dynamicRelief, payeAfterRelief, totalDeductions, netPay);
        }

        function calculateNssfTier2(grossPay) {
            const NssfTieriiRates = [
                { bracket: 0, rate: 0 },
                { bracket: 7000, rate: 60 },
                { bracket: 8000, rate: 120 },
                { bracket: 9000, rate: 180 },
                { bracket: 10000, rate: 240 },
                { bracket: 11000, rate: 300 },
                { bracket: 12000, rate: 360 },
                { bracket: 13000, rate: 420 },
                { bracket: 14000, rate: 480 },
                { bracket: 15000, rate: 540 },
                { bracket: 16000, rate: 600 },
                { bracket: 17000, rate: 660 },
                { bracket: 18000, rate: 720 }
            ];

            let nssfTier2 = 0;

            // Find the applicable rate based on the grossPay
            for (let i = NssfTieriiRates.length - 1; i >= 0; i--) {
                if (grossPay >= NssfTieriiRates[i].bracket) {
                    nssfTier2 = NssfTieriiRates[i].rate;
                    break;
                }
            }

            return nssfTier2;
        }

        function calculateNhif(grossPay) {
            const nhifRates = [
                { bracket: 0, rate: 150 },
                { bracket: 6000, rate: 300 },
                { bracket: 8000, rate: 400 },
                { bracket: 12000, rate: 500 },
                { bracket: 15000, rate: 600 },
                { bracket: 20000, rate: 750 },
                { bracket: 25000, rate: 850 },
                { bracket: 30000, rate: 900 },
                { bracket: 35000, rate: 950 },
                { bracket: 40000, rate: 1000 },
                { bracket: 45000, rate: 1100 },
                { bracket: 50000, rate: 1200 },
                { bracket: 60000, rate: 1300 },
                { bracket: 70000, rate: 1400 },
                { bracket: 80000, rate: 1500 },
                { bracket: 90000, rate: 1600 },
                { bracket: 100000, rate: 1700 }
            ];

            let nhif = 0;

            for (let i = nhifRates.length - 1; i >= 0; i--) {
                if (grossPay >= nhifRates[i].bracket) {
                    nhif = nhifRates[i].rate;
                    break;
                }
            }

            return nhif;
        }

        function calculateHousingLevy(grossPay) {
   // Example Housing Levy rate

    if (grossPay <= 24000) {
        return grossPay * housingLevyRate; // Example Housing Levy rate for the lowest bracket
    } else {
        // Adjust the condition for other income brackets
        // Add more conditions for other income brackets if needed
        return 0;
    }
}
function calculateDeductions(grossPay) {
    const housingLevyRate = 0.015;
    // Constants for NSSF deductions
    const nssfTier1 = 360; // Example NSSF Tier I deduction
    const nssfTier2 = calculateNssfTier2(grossPay);

    // NHIF and Housing Levy deductions
    const nhif = calculateNhif(grossPay);

    const housingLevy = grossPay * housingLevyRate;

    // Define income brackets, rates, and a base relief
    const brackets = [0, 24000, 32333.33, 499999.99, 799999.99];
    const rates = [0.1, 0.25, 0.3, 0.325, 0.35];
    const baseReliefs = [2400 + nhif * 0.15]; // Example base reliefs for each bracket

    // Calculate taxable pay
    let taxablePay = grossPay - nssfTier1 - nssfTier2;

    // Calculate PAYE before relief
    let payeBeforeRelief = 0;

    for (let i = 0; i < brackets.length - 1; i++) {
        if (taxablePay <= 0) {
            break;
        }

        const taxableAmount = Math.min(brackets[i + 1] - brackets[i], taxablePay);
        payeBeforeRelief += taxableAmount * rates[i];
        taxablePay -= taxableAmount;
    }

    // Apply base relief based on the bracket
    const baseRelief = baseReliefs.find((relief, index) => grossPay > brackets[index]);

    // Calculate dynamic relief based on taxable pay
    const dynamicRelief = Math.min(payeBeforeRelief, baseRelief);

    // Apply dynamic relief
    const payeAfterRelief = Math.max(0, payeBeforeRelief - dynamicRelief);

    // Calculate total deductions
    const totalDeductions = nssfTier1 + nssfTier2 + nhif + housingLevy + payeAfterRelief;

    // Calculate net pay
    const netPay = grossPay - totalDeductions;

    return { nssfTier1, nssfTier2, nhif, housingLevy, payeBeforeRelief, dynamicRelief, payeAfterRelief, totalDeductions, netPay };
}



        function displayResults(grossPay, nssfTier1, nssfTier2, nhif, housingLevy, payeBeforeRelief, dynamicRelief, payeAfterRelief, totalDeductions, netPay) {
            // Display results
            const resultsDiv = document.getElementById('results');
            resultsDiv.innerHTML = `
      <div class="container">
    <div class="row">
        <div class="col-md-6 col-md-offset-3 body-main">
            <div class="col-md-12">
               <div class="row">
                    <div class="col-md-4">
                        <img class="img" alt="" src="" />
                    </div>
                    <div class="col-md-8 text-right">
                        <h4 style="color: #F81D2D;"><strong>Ndoni Farm Inputs</strong></h4>
                        <p>Machakos</p>
                        <p>P.O Box</p>
                        <p>example@gmail.com</p>
                    </div>
                </div>
                <br />
                <div class="row">
                    <div class="col-md-12 text-center">
                        <h2>Salary Payslip</h2>
                        <h5>04854654101</h5>
                    </div>
                </div>
                <br />
                <div>
                    <table class="table">
                        <thead>
                            <tr>
                                <th><h5>Description</h5></th>
                                <th><h5>Amount</h5></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="col-md-9">Gross Salary</td>
                                <td class="col-md-3"><i class="fas fa-check" area-hidden="true"></i><span id="grosssalary">Kshs ${grossPay.toFixed(2)}</span> </td>
                            </tr>
                            <tr>
                                <td class="col-md-9">NSSF Tier (i)</td>
                                <td class="col-md-3"><i class="fas fa-check" area-hidden="true"></i> <span id="nssftieri"></span>${nssfTier1.toFixed(2)} </td>
                            </tr>
                            <tr>
                                <td class="col-md-9">NSSF Tier (ii)</td>
                                <td class="col-md-3"><i class="fas fa-check" area-hidden="true"></i> <span id="nssftierii"></span>${nssfTier2.toFixed(2)}</td>
                            </tr>
                            <tr>
                                <td class="col-md-9">NHIF</td>
                                <td class="col-md-3"><i class="fas fa-check" area-hidden="true"></i><span id="nhif"></span> ${nhif.toFixed(2)} </td>
                            </tr>
                            <tr>
                                <td class="col-md-9">Housing Levy</td>
                                <td class="col-md-3"><i class="fas fa-check" area-hidden="true"></i><span id="nhif"></span>${housingLevy.toFixed(2)} </td>
                            </tr>
                            <tr>
                                <td class="col-md-9"></td>
                                <td class="col-md-3"><i class="fas fa-check" area-hidden="true"></i><span id="nhif"></span> ${nhif.toFixed(2)} </td>
                            </tr>
                            <tr>
                                <td class="text-right">
                                <p>
                                    <strong>PAYE before relief:</strong>
                                </p>
                                <p>
                                    <strong>Reliefs: </strong>
                                </p>
							    <p>
                                    <strong>PAYE after relief: </strong>
                                </p>
							    <p>
                                    <strong>Total Deductions: </strong>
                                </p>
                               
							    </td>
                                <td>
                                <p>
                                    <strong><i class="fas fa-check" area-hidden="true"></i><span id="payebeforerelief"></span> ${payeBeforeRelief.toFixed(2)}</strong>
                                </p>
                                <p>
                                    <strong><i class="fas fa-check" area-hidden="true"></i> <span id="reliefs"></span>${dynamicRelief.toFixed(2)}</strong>
                                </p>
							    <p>
                                    <strong><i class="fas fa-check" area-hidden="true"></i> <span id="payeafterrelief"></span>${payeAfterRelief.toFixed(2)}</strong>
                                </p>
							    <p>
                                    <strong><i class="fas fa-check" area-hidden="true"></i> <span id="totaldeductions"></span>${totalDeductions.toFixed(2)}</strong>
                                </p>
							    </td>
                            </tr>
                            <tr style="color: #F81D2D;">
                                <td class="text-right"><h4><strong>Net Pay:</strong></h4></td>
                                <td class="text-left"><h4><strong><i class="fas fa-check" area-hidden="true"></i> ${netPay.toFixed(2)} </strong></h4></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div>
                    <div class="col-md-12">
                        <p><b>Date :</b> 6 June 2019</p>
                        <br />
                        <p><b>Signature</b></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    `;
        }
    </script>
</body>










</html>
